/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.naming.core.ClusterOperator;
import com.alibaba.nacos.naming.core.v2.ServiceManager;
import com.alibaba.nacos.naming.core.v2.metadata.ClusterMetadata;
import com.alibaba.nacos.naming.core.v2.metadata.NamingMetadataOperateService;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import java.util.Optional;

@org.springframework.stereotype.Service
public class ClusterOperatorV2Impl
implements ClusterOperator {
    private final NamingMetadataOperateService metadataOperateService;

    public ClusterOperatorV2Impl(NamingMetadataOperateService metadataOperateService) {
        this.metadataOperateService = metadataOperateService;
    }

    @Override
    public void updateClusterMetadata(String namespaceId, String serviceName, String clusterName, ClusterMetadata clusterMetadata) throws NacosException {
        String groupName = NamingUtils.getGroupName((String)serviceName);
        String serviceNameWithoutGroup = NamingUtils.getServiceName((String)serviceName);
        this.updateClusterMetadata(namespaceId, groupName, serviceNameWithoutGroup, clusterName, clusterMetadata);
    }

    @Override
    public void updateClusterMetadata(String namespaceId, String groupName, String serviceName, String clusterName, ClusterMetadata clusterMetadata) throws NacosException {
        Optional<Service> service = ServiceManager.getInstance().getSingletonIfExist(namespaceId, groupName, serviceName);
        if (service.isEmpty()) {
            throw new NacosException(400, String.format("service not found groupName: %s,serviceName: %s", groupName, serviceName));
        }
        this.metadataOperateService.addClusterMetadata(service.get(), clusterName, clusterMetadata);
    }
}

