/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core;

import com.alibaba.nacos.naming.cluster.ServerStatusManager;
import com.alibaba.nacos.naming.core.Operator;
import com.alibaba.nacos.naming.core.v2.client.manager.ClientManager;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.misc.SwitchManager;
import com.alibaba.nacos.naming.model.vo.MetricsInfoVo;
import com.alibaba.nacos.naming.monitor.MetricsMonitor;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OperatorV2Impl
implements Operator {
    @Resource
    private SwitchDomain switchDomain;
    @Resource
    private SwitchManager switchManager;
    @Resource
    private ServerStatusManager serverStatusManager;
    @Resource
    private ClientManager clientManager;

    @Override
    public SwitchDomain switches() {
        return this.switchDomain;
    }

    @Override
    public void updateSwitch(String entry, String value, boolean debug) throws Exception {
        this.switchManager.update(entry, value, debug);
    }

    @Override
    public MetricsInfoVo metrics(boolean onlyStatus) {
        MetricsInfoVo metricsInfoVo = new MetricsInfoVo();
        metricsInfoVo.setStatus(this.serverStatusManager.getServerStatus().name());
        if (onlyStatus) {
            return metricsInfoVo;
        }
        int connectionBasedClient = 0;
        int ephemeralIpPortClient = 0;
        int persistentIpPortClient = 0;
        int responsibleClientCount = 0;
        Collection<String> allClientId = this.clientManager.allClientId();
        for (String clientId : allClientId) {
            if (clientId.contains("#")) {
                if (clientId.endsWith("false")) {
                    ++persistentIpPortClient;
                } else {
                    ++ephemeralIpPortClient;
                }
            } else {
                ++connectionBasedClient;
            }
            if (!this.clientManager.isResponsibleClient(this.clientManager.getClient(clientId))) continue;
            ++responsibleClientCount;
        }
        metricsInfoVo.setServiceCount(MetricsMonitor.getDomCountMonitor().get());
        metricsInfoVo.setInstanceCount(MetricsMonitor.getIpCountMonitor().get());
        metricsInfoVo.setSubscribeCount(MetricsMonitor.getSubscriberCount().get());
        metricsInfoVo.setClientCount(allClientId.size());
        metricsInfoVo.setConnectionBasedClientCount(connectionBasedClient);
        metricsInfoVo.setEphemeralIpPortClientCount(ephemeralIpPortClient);
        metricsInfoVo.setPersistentIpPortClientCount(persistentIpPortClient);
        metricsInfoVo.setResponsibleClientCount(responsibleClientCount);
        metricsInfoVo.setCpu(Float.valueOf(EnvUtil.getCpu()));
        metricsInfoVo.setLoad(Float.valueOf(EnvUtil.getLoad()));
        metricsInfoVo.setMem(Float.valueOf(EnvUtil.getMem()));
        return metricsInfoVo;
    }

    @Override
    public void setLogLevel(String logName, String logLevel) {
        Loggers.setLogLevel(logName, logLevel);
    }
}

