/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.healthcheck.v2.processor;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.trace.event.naming.HealthStateChangeTraceEvent;
import com.alibaba.nacos.naming.core.DistroMapper;
import com.alibaba.nacos.naming.core.v2.pojo.HealthCheckInstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.healthcheck.v2.HealthCheckTaskV2;
import com.alibaba.nacos.naming.healthcheck.v2.PersistentHealthStatusSynchronizer;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HealthCheckCommonV2 {
    @Autowired
    private DistroMapper distroMapper;
    @Autowired
    private SwitchDomain switchDomain;
    @Autowired
    private PersistentHealthStatusSynchronizer healthStatusSynchronizer;

    public void reEvaluateCheckRt(long checkRt, HealthCheckTaskV2 task, SwitchDomain.HealthParams params) {
        task.setCheckRtLast(checkRt);
        if (checkRt > task.getCheckRtWorst()) {
            task.setCheckRtWorst(checkRt);
        }
        if (checkRt < task.getCheckRtBest()) {
            task.setCheckRtBest(checkRt);
        }
        if ((checkRt = (long)(params.getFactor() * (float)task.getCheckRtNormalized() + (1.0f - params.getFactor()) * (float)checkRt)) > (long)params.getMax()) {
            checkRt = params.getMax();
        }
        if (checkRt < (long)params.getMin()) {
            checkRt = params.getMin();
        }
        task.setCheckRtNormalized(checkRt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkOk(HealthCheckTaskV2 task, Service service, String msg) {
        try {
            HealthCheckInstancePublishInfo instance = (HealthCheckInstancePublishInfo)task.getClient().getInstancePublishInfo(service);
            if (instance == null) {
                return;
            }
            try {
                if (!instance.isHealthy()) {
                    String serviceName = service.getGroupedServiceName();
                    String clusterName = instance.getCluster();
                    if (instance.getOkCount().incrementAndGet() >= this.switchDomain.getCheckTimes()) {
                        if (this.switchDomain.isHealthCheckEnabled(serviceName) && !task.isCancelled() && this.distroMapper.responsible(task.getClient().getResponsibleId())) {
                            this.healthStatusSynchronizer.instanceHealthStatusChange(true, task.getClient(), service, instance);
                            Loggers.EVT_LOG.info("serviceName: {} {POS} {IP-ENABLED} valid: {}:{}@{}, region: {}, msg: {}", new Object[]{serviceName, instance.getIp(), instance.getPort(), clusterName, "unknown", msg});
                            NotifyCenter.publishEvent((Event)new HealthStateChangeTraceEvent(System.currentTimeMillis(), service.getNamespace(), service.getGroup(), service.getName(), instance.getIp(), instance.getPort(), true, msg));
                        }
                    } else {
                        Loggers.EVT_LOG.info("serviceName: {} {OTHER} {IP-ENABLED} pre-valid: {}:{}@{} in {}, msg: {}", new Object[]{serviceName, instance.getIp(), instance.getPort(), clusterName, instance.getOkCount(), msg});
                    }
                }
            }
            finally {
                instance.resetFailCount();
                instance.finishCheck();
            }
        }
        catch (Throwable t) {
            Loggers.SRV_LOG.error("[CHECK-OK] error when close check task.", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkFail(HealthCheckTaskV2 task, Service service, String msg) {
        try {
            HealthCheckInstancePublishInfo instance = (HealthCheckInstancePublishInfo)task.getClient().getInstancePublishInfo(service);
            if (instance == null) {
                return;
            }
            try {
                if (instance.isHealthy()) {
                    String serviceName = service.getGroupedServiceName();
                    String clusterName = instance.getCluster();
                    if (instance.getFailCount().incrementAndGet() >= this.switchDomain.getCheckTimes()) {
                        if (this.switchDomain.isHealthCheckEnabled(serviceName) && !task.isCancelled() && this.distroMapper.responsible(task.getClient().getResponsibleId())) {
                            this.healthStatusSynchronizer.instanceHealthStatusChange(false, task.getClient(), service, instance);
                            Loggers.EVT_LOG.info("serviceName: {} {POS} {IP-DISABLED} invalid: {}:{}@{}, region: {}, msg: {}", new Object[]{serviceName, instance.getIp(), instance.getPort(), clusterName, "unknown", msg});
                            NotifyCenter.publishEvent((Event)new HealthStateChangeTraceEvent(System.currentTimeMillis(), service.getNamespace(), service.getGroup(), service.getName(), instance.getIp(), instance.getPort(), false, msg));
                        }
                    } else {
                        Loggers.EVT_LOG.info("serviceName: {} {OTHER} {IP-DISABLED} pre-invalid: {}:{}@{} in {}, msg: {}", new Object[]{serviceName, instance.getIp(), instance.getPort(), clusterName, instance.getFailCount(), msg});
                    }
                }
            }
            finally {
                instance.resetOkCount();
                instance.finishCheck();
            }
        }
        catch (Throwable t) {
            Loggers.SRV_LOG.error("[CHECK-FAIL] error when close check task.", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkFailNow(HealthCheckTaskV2 task, Service service, String msg) {
        try {
            HealthCheckInstancePublishInfo instance = (HealthCheckInstancePublishInfo)task.getClient().getInstancePublishInfo(service);
            if (null == instance) {
                return;
            }
            try {
                if (instance.isHealthy()) {
                    String serviceName = service.getGroupedServiceName();
                    String clusterName = instance.getCluster();
                    if (this.switchDomain.isHealthCheckEnabled(serviceName) && !task.isCancelled() && this.distroMapper.responsible(task.getClient().getResponsibleId())) {
                        this.healthStatusSynchronizer.instanceHealthStatusChange(false, task.getClient(), service, instance);
                        Loggers.EVT_LOG.info("serviceName: {} {POS} {IP-DISABLED} invalid: {}:{}@{}, region: {}, msg: {}", new Object[]{serviceName, instance.getIp(), instance.getPort(), clusterName, "unknown", msg});
                        NotifyCenter.publishEvent((Event)new HealthStateChangeTraceEvent(System.currentTimeMillis(), service.getNamespace(), service.getGroup(), service.getName(), instance.getIp(), instance.getPort(), false, msg));
                    }
                }
            }
            finally {
                instance.resetOkCount();
                instance.finishCheck();
            }
        }
        catch (Throwable t) {
            Loggers.SRV_LOG.error("[CHECK-FAIL] error when close check task.", t);
        }
    }
}

