/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.healthcheck.v2.processor;

import com.alibaba.nacos.api.naming.pojo.healthcheck.HealthCheckType;
import com.alibaba.nacos.naming.core.v2.metadata.ClusterMetadata;
import com.alibaba.nacos.naming.core.v2.pojo.HealthCheckInstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.healthcheck.v2.HealthCheckTaskV2;
import com.alibaba.nacos.naming.healthcheck.v2.processor.HealthCheckCommonV2;
import com.alibaba.nacos.naming.healthcheck.v2.processor.HealthCheckProcessorV2;
import com.alibaba.nacos.naming.misc.GlobalExecutor;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.monitor.MetricsMonitor;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Component;

@Component
public class TcpHealthCheckProcessor
implements HealthCheckProcessorV2,
Runnable {
    public static final String TYPE = HealthCheckType.TCP.name();
    public static final int CONNECT_TIMEOUT_MS = 500;
    private static final int NIO_THREAD_COUNT = EnvUtil.getAvailableProcessors((double)0.5);
    private static final long TCP_KEEP_ALIVE_MILLIS = 0L;
    private final HealthCheckCommonV2 healthCheckCommon;
    private final SwitchDomain switchDomain;
    private final Map<String, BeatKey> keyMap = new ConcurrentHashMap<String, BeatKey>();
    private final BlockingQueue<Beat> taskQueue = new LinkedBlockingQueue<Beat>();
    private final Selector selector;

    public TcpHealthCheckProcessor(HealthCheckCommonV2 healthCheckCommon, SwitchDomain switchDomain) {
        this.healthCheckCommon = healthCheckCommon;
        this.switchDomain = switchDomain;
        try {
            this.selector = Selector.open();
            GlobalExecutor.submitTcpCheck(this);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while initializing SuperSense(TM).");
        }
    }

    @Override
    public void process(HealthCheckTaskV2 task, Service service, ClusterMetadata metadata) {
        HealthCheckInstancePublishInfo instance = (HealthCheckInstancePublishInfo)task.getClient().getInstancePublishInfo(service);
        if (null == instance) {
            return;
        }
        if (!instance.tryStartCheck()) {
            Loggers.SRV_LOG.warn("[HEALTH-CHECK-V2] tcp check started before last one finished, service: {} : {} : {}:{}", new Object[]{service.getNameSpaceGroupedServiceName(), instance.getCluster(), instance.getIp(), instance.getPort()});
            this.healthCheckCommon.reEvaluateCheckRt(task.getCheckRtNormalized() * 2L, task, this.switchDomain.getTcpHealthParams());
            return;
        }
        this.taskQueue.add(new Beat(task, service, metadata, instance));
        MetricsMonitor.getTcpHealthCheckMonitor().incrementAndGet();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    private void processTask() throws Exception {
        LinkedList<TaskProcessor> tasks = new LinkedList<TaskProcessor>();
        do {
            Beat beat;
            if ((beat = this.taskQueue.poll(250L, TimeUnit.MILLISECONDS)) == null) {
                return;
            }
            tasks.add(new TaskProcessor(beat));
        } while (this.taskQueue.size() > 0 && tasks.size() < NIO_THREAD_COUNT * 64);
        for (Future f : GlobalExecutor.invokeAllTcpSuperSenseTask(tasks)) {
            f.get();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        while (true) {
            try {
                block3: while (true) {
                    this.processTask();
                    readyCount = this.selector.selectNow();
                    if (readyCount <= 0) continue;
                    iter = this.selector.selectedKeys().iterator();
                    while (true) {
                        if (iter.hasNext()) ** break;
                        continue block3;
                        key = iter.next();
                        iter.remove();
                        GlobalExecutor.executeTcpSuperSense(new PostProcessor(key));
                    }
                    break;
                }
            }
            catch (Throwable e) {
                Loggers.SRV_LOG.error("[HEALTH-CHECK-V2] error while processing NIO task", e);
                continue;
            }
            break;
        }
    }

    private class Beat {
        private final HealthCheckTaskV2 task;
        private final Service service;
        private final ClusterMetadata metadata;
        private final HealthCheckInstancePublishInfo instance;
        long startTime = System.currentTimeMillis();

        public Beat(HealthCheckTaskV2 task, Service service, ClusterMetadata metadata, HealthCheckInstancePublishInfo instance) {
            this.task = task;
            this.service = service;
            this.metadata = metadata;
            this.instance = instance;
        }

        public void setStartTime(long time) {
            this.startTime = time;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public HealthCheckTaskV2 getTask() {
            return this.task;
        }

        public Service getService() {
            return this.service;
        }

        public ClusterMetadata getMetadata() {
            return this.metadata;
        }

        public HealthCheckInstancePublishInfo getInstance() {
            return this.instance;
        }

        public boolean isHealthy() {
            return System.currentTimeMillis() - this.startTime < TimeUnit.SECONDS.toMillis(30L);
        }

        public void finishCheck() {
            this.instance.finishCheck();
        }

        public void finishCheck(boolean success, boolean now, long rt, String msg) {
            if (success) {
                TcpHealthCheckProcessor.this.healthCheckCommon.checkOk(this.task, this.service, msg);
            } else {
                if (now) {
                    TcpHealthCheckProcessor.this.healthCheckCommon.checkFailNow(this.task, this.service, msg);
                } else {
                    TcpHealthCheckProcessor.this.healthCheckCommon.checkFail(this.task, this.service, msg);
                }
                TcpHealthCheckProcessor.this.keyMap.remove(this.toString());
            }
            TcpHealthCheckProcessor.this.healthCheckCommon.reEvaluateCheckRt(rt, this.task, TcpHealthCheckProcessor.this.switchDomain.getTcpHealthParams());
        }

        public String toString() {
            return this.service.getNameSpaceGroupedServiceName() + ":" + this.instance.getCluster() + ":" + this.instance.getIp() + ":" + this.instance.getPort();
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Beat)) {
                return false;
            }
            return this.toString().equals(obj.toString());
        }
    }

    private class TaskProcessor
    implements Callable<Void> {
        private static final int MAX_WAIT_TIME_MILLISECONDS = 500;
        Beat beat;

        public TaskProcessor(Beat beat) {
            this.beat = beat;
        }

        @Override
        public Void call() {
            block7: {
                long waited = System.currentTimeMillis() - this.beat.getStartTime();
                if (waited > 500L) {
                    Loggers.SRV_LOG.warn("beat task waited too long: " + waited + "ms");
                }
                SocketChannel channel = null;
                try {
                    HealthCheckInstancePublishInfo instance = this.beat.getInstance();
                    BeatKey beatKey = TcpHealthCheckProcessor.this.keyMap.get(this.beat.toString());
                    if (beatKey != null && beatKey.key.isValid()) {
                        if (System.currentTimeMillis() - beatKey.birthTime < 0L) {
                            instance.finishCheck();
                            return null;
                        }
                        beatKey.key.cancel();
                        beatKey.key.channel().close();
                    }
                    channel = SocketChannel.open();
                    channel.configureBlocking(false);
                    channel.socket().setSoLinger(false, -1);
                    channel.socket().setReuseAddress(true);
                    channel.socket().setKeepAlive(true);
                    channel.socket().setTcpNoDelay(true);
                    ClusterMetadata cluster = this.beat.getMetadata();
                    int port = cluster.isUseInstancePortForCheck() ? instance.getPort() : cluster.getHealthyCheckPort();
                    channel.connect(new InetSocketAddress(instance.getIp(), port));
                    SelectionKey key = channel.register(TcpHealthCheckProcessor.this.selector, 9);
                    key.attach(this.beat);
                    TcpHealthCheckProcessor.this.keyMap.put(this.beat.toString(), new BeatKey(key));
                    this.beat.setStartTime(System.currentTimeMillis());
                    GlobalExecutor.scheduleTcpSuperSenseTask(new TimeOutTask(key), 500L, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    this.beat.finishCheck(false, false, TcpHealthCheckProcessor.this.switchDomain.getTcpHealthParams().getMax(), "tcp:error:" + e.getMessage());
                    if (channel == null) break block7;
                    try {
                        channel.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return null;
        }
    }

    public class PostProcessor
    implements Runnable {
        SelectionKey key;

        public PostProcessor(SelectionKey key) {
            this.key = key;
        }

        @Override
        public void run() {
            Beat beat = (Beat)this.key.attachment();
            SocketChannel channel = (SocketChannel)this.key.channel();
            try {
                if (!beat.isHealthy()) {
                    this.key.cancel();
                    this.key.channel().close();
                    beat.finishCheck();
                    return;
                }
                if (this.key.isValid() && this.key.isConnectable()) {
                    channel.finishConnect();
                    beat.finishCheck(true, false, System.currentTimeMillis() - beat.getTask().getStartTime(), "tcp:ok+");
                }
                if (this.key.isValid() && this.key.isReadable()) {
                    ByteBuffer buffer = ByteBuffer.allocate(128);
                    if (channel.read(buffer) == -1) {
                        this.key.cancel();
                        this.key.channel().close();
                    } else {
                        Loggers.SRV_LOG.warn("Tcp check ok, but the connected server responses some msg. Connection won't be closed.");
                    }
                }
            }
            catch (ConnectException e) {
                beat.finishCheck(false, true, TcpHealthCheckProcessor.this.switchDomain.getTcpHealthParams().getMax(), "tcp:unable2connect:" + e.getMessage());
            }
            catch (Exception e) {
                beat.finishCheck(false, false, TcpHealthCheckProcessor.this.switchDomain.getTcpHealthParams().getMax(), "tcp:error:" + e.getMessage());
                try {
                    this.key.cancel();
                    this.key.channel().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static class TimeOutTask
    implements Runnable {
        SelectionKey key;

        public TimeOutTask(SelectionKey key) {
            this.key = key;
        }

        @Override
        public void run() {
            if (this.key != null && this.key.isValid()) {
                SocketChannel channel = (SocketChannel)this.key.channel();
                Beat beat = (Beat)this.key.attachment();
                if (channel.isConnected()) {
                    return;
                }
                try {
                    channel.finishConnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    beat.finishCheck(false, false, beat.getTask().getCheckRtNormalized() * 2L, "tcp:timeout");
                    this.key.cancel();
                    this.key.channel().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static class BeatKey {
        public SelectionKey key;
        public long birthTime;

        public BeatKey(SelectionKey key) {
            this.key = key;
            this.birthTime = System.currentTimeMillis();
        }
    }
}

