/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.push;

import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.SmartSubscriber;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.task.NacosTask;
import com.alibaba.nacos.naming.core.v2.event.service.ServiceEvent;
import com.alibaba.nacos.naming.core.v2.index.NamingFuzzyWatchContextService;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.push.v2.PushConfig;
import com.alibaba.nacos.naming.push.v2.task.FuzzyWatchChangeNotifyTask;
import com.alibaba.nacos.naming.push.v2.task.FuzzyWatchPushDelayTaskEngine;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class NamingFuzzyWatchChangeNotifier
extends SmartSubscriber {
    private NamingFuzzyWatchContextService namingFuzzyWatchContextService;
    private FuzzyWatchPushDelayTaskEngine fuzzyWatchPushDelayTaskEngine;

    public NamingFuzzyWatchChangeNotifier(NamingFuzzyWatchContextService namingFuzzyWatchContextService, FuzzyWatchPushDelayTaskEngine fuzzyWatchPushDelayTaskEngine) {
        this.fuzzyWatchPushDelayTaskEngine = fuzzyWatchPushDelayTaskEngine;
        this.namingFuzzyWatchContextService = namingFuzzyWatchContextService;
        NotifyCenter.registerSubscriber((Subscriber)this);
    }

    public List<Class<? extends Event>> subscribeTypes() {
        LinkedList<Class<? extends Event>> result = new LinkedList<Class<? extends Event>>();
        result.add(ServiceEvent.ServiceChangedEvent.class);
        return result;
    }

    public void onEvent(Event event) {
        ServiceEvent.ServiceChangedEvent serviceChangedEvent;
        if (event instanceof ServiceEvent.ServiceChangedEvent && this.namingFuzzyWatchContextService.syncServiceContext((serviceChangedEvent = (ServiceEvent.ServiceChangedEvent)event).getService(), serviceChangedEvent.getChangedType())) {
            this.generateFuzzyWatchChangeNotifyTask(serviceChangedEvent.getService(), serviceChangedEvent.getChangedType());
        }
    }

    private void generateFuzzyWatchChangeNotifyTask(com.alibaba.nacos.naming.core.v2.pojo.Service service, String changedType) {
        String serviceKey = NamingUtils.getServiceKey((String)service.getNamespace(), (String)service.getGroup(), (String)service.getName());
        Set<String> fuzzyWatchedClients = this.namingFuzzyWatchContextService.getFuzzyWatchedClients(service);
        Loggers.SRV_LOG.info("FUZZY_WATCH:serviceKey {}   has {} clients  fuzzy watched", (Object)serviceKey, (Object)(fuzzyWatchedClients == null ? 0 : fuzzyWatchedClients.size()));
        for (String clientId : fuzzyWatchedClients) {
            FuzzyWatchChangeNotifyTask fuzzyWatchChangeNotifyTask = new FuzzyWatchChangeNotifyTask(serviceKey, changedType, clientId, PushConfig.getInstance().getPushTaskDelay());
            this.fuzzyWatchPushDelayTaskEngine.addTask(FuzzyWatchPushDelayTaskEngine.getTaskKey((NacosTask)fuzzyWatchChangeNotifyTask), fuzzyWatchChangeNotifyTask);
        }
    }
}

