/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.push;

import com.alibaba.nacos.api.naming.remote.request.NamingFuzzyWatchSyncRequest;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.SmartSubscriber;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.task.BatchTaskCounter;
import com.alibaba.nacos.common.task.NacosTask;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.FuzzyGroupKeyPattern;
import com.alibaba.nacos.naming.core.v2.event.client.ClientOperationEvent;
import com.alibaba.nacos.naming.core.v2.index.NamingFuzzyWatchContextService;
import com.alibaba.nacos.naming.push.v2.PushConfig;
import com.alibaba.nacos.naming.push.v2.task.FuzzyWatchPushDelayTaskEngine;
import com.alibaba.nacos.naming.push.v2.task.FuzzyWatchSyncNotifyTask;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class NamingFuzzyWatchSyncNotifier
extends SmartSubscriber {
    private NamingFuzzyWatchContextService namingFuzzyWatchContextService;
    private FuzzyWatchPushDelayTaskEngine fuzzyWatchPushDelayTaskEngine;
    static final int BATCH_SIZE = 10;

    public NamingFuzzyWatchSyncNotifier(NamingFuzzyWatchContextService namingFuzzyWatchContextService, FuzzyWatchPushDelayTaskEngine fuzzyWatchPushDelayTaskEngine) {
        this.namingFuzzyWatchContextService = namingFuzzyWatchContextService;
        this.fuzzyWatchPushDelayTaskEngine = fuzzyWatchPushDelayTaskEngine;
        NotifyCenter.registerSubscriber((Subscriber)this);
    }

    public List<Class<? extends Event>> subscribeTypes() {
        LinkedList<Class<? extends Event>> result = new LinkedList<Class<? extends Event>>();
        result.add(ClientOperationEvent.ClientFuzzyWatchEvent.class);
        return result;
    }

    public void onEvent(Event event) {
        if (event instanceof ClientOperationEvent.ClientFuzzyWatchEvent) {
            ClientOperationEvent.ClientFuzzyWatchEvent clientFuzzyWatchEvent = (ClientOperationEvent.ClientFuzzyWatchEvent)event;
            this.handleClientFuzzyWatchEvent(clientFuzzyWatchEvent);
        }
    }

    private void handleClientFuzzyWatchEvent(ClientOperationEvent.ClientFuzzyWatchEvent clientFuzzyWatchEvent) {
        String completedPattern = clientFuzzyWatchEvent.getGroupKeyPattern();
        Set<String> patternMatchedServiceKeys = this.namingFuzzyWatchContextService.matchServiceKeys(completedPattern);
        HashSet<String> clientReceivedGroupKeys = new HashSet<String>(clientFuzzyWatchEvent.getClientReceivedServiceKeys());
        List groupKeyStates = FuzzyGroupKeyPattern.diffGroupKeys(patternMatchedServiceKeys, clientReceivedGroupKeys);
        if (this.namingFuzzyWatchContextService.reachToUpLimit(completedPattern)) {
            groupKeyStates.removeIf(item -> !item.isExist());
        }
        String syncType = clientFuzzyWatchEvent.isInitializing() ? "FUZZY_WATCH_INIT_NOTIFY" : "FUZZY_WATCH_DIFF_SYNC_NOTIFY";
        Set<NamingFuzzyWatchSyncRequest.Context> syncContext = this.convert(groupKeyStates);
        if (CollectionUtils.isNotEmpty((Collection)groupKeyStates)) {
            Set<Set<NamingFuzzyWatchSyncRequest.Context>> dividedServices = this.divideServiceByBatch(syncContext);
            BatchTaskCounter batchTaskCounter = new BatchTaskCounter(dividedServices.size());
            int currentBatch = 1;
            for (Set<NamingFuzzyWatchSyncRequest.Context> batchData : dividedServices) {
                FuzzyWatchSyncNotifyTask fuzzyWatchSyncNotifyTask = new FuzzyWatchSyncNotifyTask(clientFuzzyWatchEvent.getClientId(), completedPattern, syncType, batchData, PushConfig.getInstance().getPushTaskRetryDelay());
                fuzzyWatchSyncNotifyTask.setBatchTaskCounter(batchTaskCounter);
                fuzzyWatchSyncNotifyTask.setTotalBatch(dividedServices.size());
                fuzzyWatchSyncNotifyTask.setCurrentBatch(currentBatch);
                this.fuzzyWatchPushDelayTaskEngine.addTask(FuzzyWatchPushDelayTaskEngine.getTaskKey((NacosTask)fuzzyWatchSyncNotifyTask), fuzzyWatchSyncNotifyTask);
                ++currentBatch;
            }
        } else if ("FUZZY_WATCH_INIT_NOTIFY".equals(syncType)) {
            FuzzyWatchSyncNotifyTask fuzzyWatchSyncNotifyTask = new FuzzyWatchSyncNotifyTask(clientFuzzyWatchEvent.getClientId(), completedPattern, "FINISH_FUZZY_WATCH_INIT_NOTIFY", null, PushConfig.getInstance().getPushTaskRetryDelay());
            this.fuzzyWatchPushDelayTaskEngine.addTask(FuzzyWatchPushDelayTaskEngine.getTaskKey((NacosTask)fuzzyWatchSyncNotifyTask), fuzzyWatchSyncNotifyTask);
        }
    }

    private Set<Set<NamingFuzzyWatchSyncRequest.Context>> divideServiceByBatch(Collection<NamingFuzzyWatchSyncRequest.Context> matchedService) {
        HashSet<Set<NamingFuzzyWatchSyncRequest.Context>> result = new HashSet<Set<NamingFuzzyWatchSyncRequest.Context>>();
        if (matchedService.isEmpty()) {
            return result;
        }
        HashSet<NamingFuzzyWatchSyncRequest.Context> currentBatch = new HashSet<NamingFuzzyWatchSyncRequest.Context>();
        for (NamingFuzzyWatchSyncRequest.Context groupedServiceName : matchedService) {
            currentBatch.add(groupedServiceName);
            if (currentBatch.size() < 10) continue;
            result.add(currentBatch);
            currentBatch = new HashSet();
        }
        if (!currentBatch.isEmpty()) {
            result.add(currentBatch);
        }
        return result;
    }

    private Set<NamingFuzzyWatchSyncRequest.Context> convert(List<FuzzyGroupKeyPattern.GroupKeyState> diffGroupKeys) {
        HashSet<NamingFuzzyWatchSyncRequest.Context> syncContext = new HashSet<NamingFuzzyWatchSyncRequest.Context>();
        for (FuzzyGroupKeyPattern.GroupKeyState groupKeyState : diffGroupKeys) {
            NamingFuzzyWatchSyncRequest.Context context = new NamingFuzzyWatchSyncRequest.Context();
            context.setServiceKey(groupKeyState.getGroupKey());
            context.setChangedType(groupKeyState.isExist() ? "ADD_SERVICE" : "DELETE_SERVICE");
            syncContext.add(context);
        }
        return syncContext;
    }
}

