/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.push.v2;

import com.alibaba.nacos.core.config.AbstractDynamicConfig;
import com.alibaba.nacos.sys.env.EnvUtil;

public class PushConfig
extends AbstractDynamicConfig {
    private static final String PUSH = "Push";
    private static final PushConfig INSTANCE = new PushConfig();
    private long pushTaskDelay = 500L;
    private long pushTaskTimeout = 5000L;
    private long pushTaskRetryDelay = 1000L;

    private PushConfig() {
        super(PUSH);
        this.resetConfig();
    }

    protected void getConfigFromEnv() {
        this.pushTaskDelay = (Long)EnvUtil.getProperty((String)"nacos.naming.push.pushTaskDelay", Long.class, (Object)500L);
        this.pushTaskTimeout = (Long)EnvUtil.getProperty((String)"nacos.naming.push.pushTaskTimeout", Long.class, (Object)5000L);
        this.pushTaskRetryDelay = (Long)EnvUtil.getProperty((String)"nacos.naming.push.pushTaskRetryDelay", Long.class, (Object)1000L);
    }

    protected String printConfig() {
        return "PushConfig{pushTaskDelay=" + this.pushTaskDelay + ", pushTaskTimeout=" + this.pushTaskTimeout + ", pushTaskRetryDelay=" + this.pushTaskRetryDelay + "}";
    }

    public static PushConfig getInstance() {
        return INSTANCE;
    }

    public long getPushTaskDelay() {
        return this.pushTaskDelay;
    }

    public long getPushTaskTimeout() {
        return this.pushTaskTimeout;
    }

    public long getPushTaskRetryDelay() {
        return this.pushTaskRetryDelay;
    }
}

