/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.push.v2.task;

import com.alibaba.nacos.api.naming.remote.request.NamingFuzzyWatchSyncRequest;
import com.alibaba.nacos.common.task.AbstractDelayTask;
import com.alibaba.nacos.common.task.BatchTaskCounter;
import com.alibaba.nacos.naming.misc.Loggers;
import java.util.HashSet;
import java.util.Set;

public class FuzzyWatchSyncNotifyTask
extends AbstractDelayTask {
    private final String clientId;
    private final String pattern;
    private final Set<NamingFuzzyWatchSyncRequest.Context> syncServiceKeys;
    private final String syncType;
    private int totalBatch = 1;
    private int currentBatch = 1;
    private BatchTaskCounter batchTaskCounter;
    private long executeStartTime = System.currentTimeMillis();

    public FuzzyWatchSyncNotifyTask(String clientId, String pattern, String syncType, Set<NamingFuzzyWatchSyncRequest.Context> syncServiceKeys, long delay) {
        this.clientId = clientId;
        this.pattern = pattern;
        this.syncType = syncType;
        this.syncServiceKeys = syncServiceKeys != null ? syncServiceKeys : new HashSet<NamingFuzzyWatchSyncRequest.Context>();
        this.setTaskInterval(delay);
        this.setLastProcessTime(System.currentTimeMillis());
    }

    public int getTotalBatch() {
        return this.totalBatch;
    }

    public void setTotalBatch(int totalBatch) {
        this.totalBatch = totalBatch;
    }

    public int getCurrentBatch() {
        return this.currentBatch;
    }

    public void setCurrentBatch(int currentBatch) {
        this.currentBatch = currentBatch;
    }

    public void merge(AbstractDelayTask task) {
        if (!(task instanceof FuzzyWatchSyncNotifyTask)) {
            return;
        }
        FuzzyWatchSyncNotifyTask oldTask = (FuzzyWatchSyncNotifyTask)task;
        if (oldTask.getSyncServiceKeys() != null) {
            this.syncServiceKeys.addAll(oldTask.getSyncServiceKeys());
        }
        this.setLastProcessTime(Math.min(this.getLastProcessTime(), task.getLastProcessTime()));
        Loggers.PUSH.info("[FUZZY-WATCH-INIT-PUSH] Task merge for pattern {}", (Object)this.pattern);
    }

    public String getPattern() {
        return this.pattern;
    }

    public Set<NamingFuzzyWatchSyncRequest.Context> getSyncServiceKeys() {
        return this.syncServiceKeys;
    }

    public String getSyncType() {
        return this.syncType;
    }

    public String getClientId() {
        return this.clientId;
    }

    public BatchTaskCounter getBatchTaskCounter() {
        return this.batchTaskCounter;
    }

    public void setBatchTaskCounter(BatchTaskCounter batchTaskCounter) {
        this.batchTaskCounter = batchTaskCounter;
    }

    public long getExecuteStartTime() {
        return this.executeStartTime;
    }
}

