/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.persistence.datasource;

import com.alibaba.nacos.persistence.configuration.DatasourceConfiguration;
import com.alibaba.nacos.persistence.datasource.DataSourceService;
import com.alibaba.nacos.persistence.datasource.ExternalDataSourceServiceImpl;
import com.alibaba.nacos.persistence.datasource.LocalDataSourceServiceImpl;

public class DynamicDataSource {
    private DataSourceService localDataSourceService = null;
    private DataSourceService basicDataSourceService = null;
    private static final DynamicDataSource INSTANCE = new DynamicDataSource();

    private DynamicDataSource() {
    }

    public static DynamicDataSource getInstance() {
        return INSTANCE;
    }

    public synchronized DataSourceService getDataSource() {
        try {
            if (DatasourceConfiguration.isEmbeddedStorage()) {
                if (this.localDataSourceService == null) {
                    this.localDataSourceService = new LocalDataSourceServiceImpl();
                    this.localDataSourceService.init();
                }
                return this.localDataSourceService;
            }
            if (this.basicDataSourceService == null) {
                this.basicDataSourceService = new ExternalDataSourceServiceImpl();
                this.basicDataSourceService.init();
            }
            return this.basicDataSourceService;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

