/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.persistence.repository;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;

public final class RowMapperManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RowMapperManager.class);
    public static final MapRowMapper MAP_ROW_MAPPER = new MapRowMapper();
    public static Map<String, RowMapper> mapperMap = new HashMap<String, RowMapper>(16);

    public static <D> RowMapper<D> getRowMapper(String classFullName) {
        return mapperMap.get(classFullName);
    }

    public static synchronized <D> void registerRowMapper(String classFullName, RowMapper<D> rowMapper) {
        if (mapperMap.containsKey(classFullName)) {
            LOGGER.warn("row mapper {} conflicts, {} will be replaced by {}", new Object[]{classFullName, mapperMap.get(classFullName).getClass().getCanonicalName(), rowMapper.getClass().getCanonicalName()});
        }
        mapperMap.put(classFullName, rowMapper);
    }

    static {
        mapperMap.put(MAP_ROW_MAPPER.getClass().getCanonicalName(), MAP_ROW_MAPPER);
    }

    public static final class MapRowMapper
    implements RowMapper<Map<String, Object>> {
        public Map<String, Object> mapRow(ResultSet resultSet, int rowNum) throws SQLException {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(columnCount);
            for (int i = 1; i <= columnCount; ++i) {
                map.put(metaData.getColumnLabel(i), resultSet.getObject(i));
            }
            return map;
        }
    }
}

