/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.persistence.repository.embedded.operate;

import com.alibaba.nacos.common.utils.ExceptionUtil;
import com.alibaba.nacos.common.utils.LoggerUtils;
import com.alibaba.nacos.persistence.repository.embedded.operate.DatabaseOperate;
import com.alibaba.nacos.persistence.repository.embedded.sql.ModifyRequest;
import com.alibaba.nacos.persistence.utils.DerbyUtils;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.support.TransactionTemplate;

public interface BaseDatabaseOperate
extends DatabaseOperate {
    public static final Logger LOGGER = LoggerFactory.getLogger(BaseDatabaseOperate.class);

    default public <R> R queryOne(JdbcTemplate jdbcTemplate, String sql, Class<R> cls) {
        try {
            return (R)jdbcTemplate.queryForObject(sql, cls);
        }
        catch (IncorrectResultSizeDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LOGGER.error("[db-error] can't get connection : {}", (Object)ExceptionUtil.getAllExceptionMsg((Throwable)e));
            throw e;
        }
        catch (DataAccessException e) {
            LOGGER.error("[db-error] DataAccessException : {}", (Object)ExceptionUtil.getAllExceptionMsg((Throwable)e));
            throw e;
        }
    }

    default public <R> R queryOne(JdbcTemplate jdbcTemplate, String sql, Object[] args, Class<R> cls) {
        try {
            return (R)jdbcTemplate.queryForObject(sql, args, cls);
        }
        catch (IncorrectResultSizeDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LOGGER.error("[db-error] {}", (Object)e.toString());
            throw e;
        }
        catch (DataAccessException e) {
            LOGGER.error("[db-error] DataAccessException sql : {}, args : {}, error : {}", new Object[]{sql, args, ExceptionUtil.getAllExceptionMsg((Throwable)e)});
            throw e;
        }
    }

    default public <R> R queryOne(JdbcTemplate jdbcTemplate, String sql, Object[] args, RowMapper<R> mapper) {
        try {
            return (R)jdbcTemplate.queryForObject(sql, args, mapper);
        }
        catch (IncorrectResultSizeDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LOGGER.error("[db-error] {}", (Object)e.toString());
            throw e;
        }
        catch (DataAccessException e) {
            LOGGER.error("[db-error] DataAccessException sql : {}, args : {}, error : {}", new Object[]{sql, args, ExceptionUtil.getAllExceptionMsg((Throwable)e)});
            throw e;
        }
    }

    default public <R> List<R> queryMany(JdbcTemplate jdbcTemplate, String sql, Object[] args, RowMapper<R> mapper) {
        try {
            return jdbcTemplate.query(sql, args, mapper);
        }
        catch (CannotGetJdbcConnectionException e) {
            LOGGER.error("[db-error] {}", (Object)e.toString());
            throw e;
        }
        catch (DataAccessException e) {
            LOGGER.error("[db-error] DataAccessException sql : {}, args : {}, error : {}", new Object[]{sql, args, ExceptionUtil.getAllExceptionMsg((Throwable)e)});
            throw e;
        }
    }

    default public <R> List<R> queryMany(JdbcTemplate jdbcTemplate, String sql, Object[] args, Class<R> rClass) {
        try {
            return jdbcTemplate.queryForList(sql, args, rClass);
        }
        catch (IncorrectResultSizeDataAccessException e) {
            return null;
        }
        catch (CannotGetJdbcConnectionException e) {
            LOGGER.error("[db-error] {}", (Object)e.toString());
            throw e;
        }
        catch (DataAccessException e) {
            LOGGER.error("[db-error] DataAccessException sql : {}, args : {}, error : {}", new Object[]{sql, args, ExceptionUtil.getAllExceptionMsg((Throwable)e)});
            throw e;
        }
    }

    default public List<Map<String, Object>> queryMany(JdbcTemplate jdbcTemplate, String sql, Object[] args) {
        try {
            return jdbcTemplate.queryForList(sql, args);
        }
        catch (CannotGetJdbcConnectionException e) {
            LOGGER.error("[db-error] {}", (Object)e.toString());
            throw e;
        }
        catch (DataAccessException e) {
            LOGGER.error("[db-error] DataAccessException sql : {}, args : {}, error : {}", new Object[]{sql, args, ExceptionUtil.getAllExceptionMsg((Throwable)e)});
            throw e;
        }
    }

    default public Boolean update(TransactionTemplate transactionTemplate, JdbcTemplate jdbcTemplate, List<ModifyRequest> contexts) {
        return this.update(transactionTemplate, jdbcTemplate, contexts, null);
    }

    default public Boolean update(TransactionTemplate transactionTemplate, JdbcTemplate jdbcTemplate, List<ModifyRequest> contexts, BiConsumer<Boolean, Throwable> consumer) {
        boolean updateResult;
        block2: {
            updateResult = Boolean.FALSE;
            try {
                updateResult = (Boolean)transactionTemplate.execute(status -> {
                    String[] errSql = new String[]{null};
                    Object[][] args = new Object[][]{null};
                    try {
                        contexts.forEach(pair -> {
                            errSql[0] = pair.getSql();
                            args[0] = pair.getArgs();
                            boolean rollBackOnUpdateFail = pair.isRollBackOnUpdateFail();
                            LoggerUtils.printIfDebugEnabled((Logger)LOGGER, (String)"current sql : {}", (Object[])new Object[]{errSql[0]});
                            LoggerUtils.printIfDebugEnabled((Logger)LOGGER, (String)"current args : {}", (Object[])args[0]);
                            int row = jdbcTemplate.update(pair.getSql(), pair.getArgs());
                            if (rollBackOnUpdateFail && row < 1) {
                                LoggerUtils.printIfDebugEnabled((Logger)LOGGER, (String)"SQL update affected {} rows ", (Object[])new Object[]{row});
                                throw new IllegalTransactionStateException("Illegal transaction");
                            }
                        });
                        if (consumer != null) {
                            consumer.accept(Boolean.TRUE, null);
                        }
                        return Boolean.TRUE;
                    }
                    catch (DataIntegrityViolationException | BadSqlGrammarException e) {
                        LOGGER.error("[db-error] sql : {}, args : {}, error : {}", new Object[]{errSql[0], args[0], e.toString()});
                        if (consumer != null) {
                            consumer.accept(Boolean.FALSE, e);
                        }
                        return Boolean.FALSE;
                    }
                    catch (CannotGetJdbcConnectionException e) {
                        LOGGER.error("[db-error] sql : {}, args : {}, error : {}", new Object[]{errSql[0], args[0], e.toString()});
                        throw e;
                    }
                    catch (DataAccessException e) {
                        LOGGER.error("[db-error] DataAccessException sql : {}, args : {}, error : {}", new Object[]{errSql[0], args[0], ExceptionUtil.getAllExceptionMsg((Throwable)e)});
                        throw e;
                    }
                });
            }
            catch (IllegalTransactionStateException e) {
                LoggerUtils.printIfDebugEnabled((Logger)LOGGER, (String)"Roll back transaction for {} ", (Object[])new Object[]{e.getMessage()});
                if (consumer == null) break block2;
                consumer.accept(Boolean.FALSE, e);
            }
        }
        return updateResult;
    }

    default public Boolean doDataImport(JdbcTemplate template, List<ModifyRequest> requests) {
        String[] sql = (String[])requests.stream().map(ModifyRequest::getSql).map(DerbyUtils::insertStatementCorrection).toArray(String[]::new);
        int[] affect = template.batchUpdate(sql);
        return IntStream.of(affect).count() == (long)requests.size();
    }
}

