/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import java.util.Arrays;
import java.util.Optional;

public enum ResponseEnum {
    OK((byte)-56, "R200", "Success"),
    TOKEN_INVALID((byte)77, "R20301", "Token is invalid"),
    IP_INVALID((byte)78, "R20302", "Invalid IP"),
    FAILURE((byte)-12, "R500", "Service exception"),
    NO_RESOURCE((byte)-108, "R404", "Resource does not exist"),
    OUT_RANGE((byte)-124, "R900", "Number out of range"),
    ADD_SUCCESS((byte)33, "R20001", "Added successfully"),
    DELETE_SUCCESS((byte)34, "R20002", "Deleted successfully"),
    UPDATE_SUCCESS((byte)35, "R20003", "Updated successfully");

    @EnumValue
    private final Byte index;
    private final String code;
    private final String text;

    public static ResponseEnum ofIndex(Byte index) {
        Optional<ResponseEnum> any = Arrays.stream(ResponseEnum.values()).filter(type -> type.getIndex().equals(index)).findFirst();
        return any.orElse(null);
    }

    public static ResponseEnum ofCode(String code) {
        Optional<ResponseEnum> any = Arrays.stream(ResponseEnum.values()).filter(type -> type.getCode().equals(code)).findFirst();
        return any.orElse(null);
    }

    public static ResponseEnum ofName(String name) {
        try {
            return ResponseEnum.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Byte getIndex() {
        return this.index;
    }

    public String getCode() {
        return this.code;
    }

    public String getText() {
        return this.text;
    }

    private ResponseEnum(Byte index, String code, String text) {
        this.index = index;
        this.code = code;
        this.text = text;
    }
}

