/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.config;

import io.github.pnoker.common.config.ExchangeConfig;
import io.github.pnoker.common.constant.driver.RabbitConstant;
import io.github.pnoker.common.driver.entity.property.DriverProperty;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={ExchangeConfig.class})
public class DriverTopicConfig {
    private static final Logger log = LoggerFactory.getLogger(DriverTopicConfig.class);
    private final DriverProperty driverProperty;
    private final TopicExchange metadataExchange;
    private final TopicExchange commandExchange;

    public DriverTopicConfig(DriverProperty driverProperty, TopicExchange metadataExchange, TopicExchange commandExchange) {
        this.driverProperty = driverProperty;
        this.metadataExchange = metadataExchange;
        this.commandExchange = commandExchange;
    }

    @Bean
    Queue metadataQueue() {
        HashMap<String, Long> arguments = new HashMap<String, Long>();
        arguments.put("x-message-ttl", 30000L);
        return new Queue(RabbitConstant.QUEUE_DRIVER_METADATA_PREFIX + this.driverProperty.getClient(), false, false, true, arguments);
    }

    @Bean
    Binding metadataBinding(Queue metadataQueue) {
        Binding binding = BindingBuilder.bind((Queue)metadataQueue).to(this.metadataExchange).with("dc3.r.metadata.driver." + this.driverProperty.getService());
        binding.addArgument("x-auto-delete", (Object)true);
        return binding;
    }

    @Bean
    Queue driverCommandQueue() {
        HashMap<String, Long> arguments = new HashMap<String, Long>();
        arguments.put("x-message-ttl", 30000L);
        return new Queue(RabbitConstant.QUEUE_DRIVER_COMMAND_PREFIX + this.driverProperty.getService(), false, false, false, arguments);
    }

    @Bean
    Binding driverCommandBinding(Queue driverCommandQueue) {
        Binding binding = BindingBuilder.bind((Queue)driverCommandQueue).to(this.commandExchange).with("dc3.r.command.driver." + this.driverProperty.getService());
        binding.addArgument("x-auto-delete", (Object)true);
        return binding;
    }

    @Bean
    Queue deviceCommandQueue() {
        HashMap<String, Long> arguments = new HashMap<String, Long>();
        arguments.put("x-message-ttl", 30000L);
        return new Queue(RabbitConstant.QUEUE_DEVICE_COMMAND_PREFIX + this.driverProperty.getService(), false, false, false, arguments);
    }

    @Bean
    Binding deviceCommandBinding(Queue deviceCommandQueue) {
        Binding binding = BindingBuilder.bind((Queue)deviceCommandQueue).to(this.commandExchange).with("dc3.r.command.device." + this.driverProperty.getService());
        binding.addArgument("x-auto-delete", (Object)true);
        return binding;
    }
}

