/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.driver.entity.bean;

import io.github.pnoker.common.driver.entity.bo.DeviceBO;
import io.github.pnoker.common.driver.entity.bo.PointBO;
import io.github.pnoker.common.enums.PointTypeFlagEnum;
import io.github.pnoker.common.exception.EmptyException;
import io.github.pnoker.common.exception.OutRangeException;
import io.github.pnoker.common.utils.ArithmeticUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

public class RValue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final BigDecimal defaultBase = new BigDecimal(0);
    private static final BigDecimal defaultMultiple = new BigDecimal(1);
    private DeviceBO device;
    private PointBO point;
    private String value;

    public String getFinalValue() {
        if (Objects.isNull((Object)this.point)) {
            throw new EmptyException((CharSequence)"Point is empty", new Object[0]);
        }
        PointTypeFlagEnum valueType = Optional.ofNullable(this.point.getPointTypeFlag()).orElse(PointTypeFlagEnum.STRING);
        BigDecimal base = Optional.ofNullable(this.point.getBaseValue()).orElse(defaultBase);
        BigDecimal multiple = Optional.ofNullable(this.point.getMultiple()).orElse(defaultMultiple);
        byte decimal = Optional.ofNullable(this.point.getValueDecimal()).orElse((byte)6);
        return switch (valueType) {
            default -> throw new MatchException(null, null);
            case PointTypeFlagEnum.STRING -> this.value;
            case PointTypeFlagEnum.BYTE -> String.valueOf(this.getByteValue(this.value, base, multiple));
            case PointTypeFlagEnum.SHORT -> String.valueOf(this.getShortValue(this.value, base, multiple));
            case PointTypeFlagEnum.INT -> String.valueOf(this.getIntegerValue(this.value, base, multiple));
            case PointTypeFlagEnum.LONG -> String.valueOf(this.getLongValue(this.value, base, multiple));
            case PointTypeFlagEnum.FLOAT -> String.valueOf(this.getFloatValue(this.value, base, multiple, decimal));
            case PointTypeFlagEnum.DOUBLE -> String.valueOf(this.getDoubleValue(this.value, base, multiple, decimal));
            case PointTypeFlagEnum.BOOLEAN -> String.valueOf(this.getBooleanValue(this.value));
        };
    }

    private BigDecimal getLinearValue(BigDecimal a, String x, BigDecimal b) {
        BigDecimal bigDecimal = new BigDecimal(x);
        if (defaultMultiple.compareTo(a) == 0 && defaultBase.compareTo(b) == 0) {
            return bigDecimal;
        }
        if (defaultMultiple.compareTo(a) != 0 && defaultBase.compareTo(b) == 0) {
            return bigDecimal.multiply(a);
        }
        if (defaultMultiple.compareTo(a) == 0 && defaultBase.compareTo(b) != 0) {
            return bigDecimal.add(b);
        }
        BigDecimal multiply = a.multiply(bigDecimal);
        return multiply.add(b);
    }

    private byte getByteValue(String rawValue, BigDecimal base, BigDecimal multiple) {
        try {
            BigDecimal multiply = this.getLinearValue(multiple, rawValue, base);
            return multiply.byteValue();
        }
        catch (Exception e) {
            throw new OutRangeException((CharSequence)"Out of byte range: {} ~ {}, current: {}", new Object[]{(byte)-128, (byte)127, rawValue});
        }
    }

    private short getShortValue(String rawValue, BigDecimal base, BigDecimal multiple) {
        try {
            BigDecimal multiply = this.getLinearValue(multiple, rawValue, base);
            return multiply.shortValue();
        }
        catch (Exception e) {
            throw new OutRangeException((CharSequence)"Out of short range: {} ~ {}, current: {}", new Object[]{(short)Short.MIN_VALUE, (short)Short.MAX_VALUE, rawValue});
        }
    }

    private int getIntegerValue(String rawValue, BigDecimal base, BigDecimal multiple) {
        try {
            BigDecimal multiply = this.getLinearValue(multiple, rawValue, base);
            return multiply.intValue();
        }
        catch (Exception e) {
            throw new OutRangeException((CharSequence)"Out of int range: {} ~ {}, current: {}", new Object[]{Integer.MIN_VALUE, Integer.MAX_VALUE, rawValue});
        }
    }

    private long getLongValue(String rawValue, BigDecimal base, BigDecimal multiple) {
        try {
            BigDecimal multiply = this.getLinearValue(multiple, rawValue, base);
            return multiply.longValue();
        }
        catch (Exception e) {
            throw new OutRangeException((CharSequence)"Out of long range: {} ~ {}, current: {}", new Object[]{Long.MIN_VALUE, Long.MAX_VALUE, rawValue});
        }
    }

    private float getFloatValue(String rawValue, BigDecimal base, BigDecimal multiple, byte decimal) {
        try {
            BigDecimal multiply = this.getLinearValue(multiple, rawValue, base);
            if (Float.isInfinite(multiply.floatValue())) {
                throw new OutRangeException();
            }
            return ArithmeticUtil.round((float)multiply.floatValue(), (int)decimal);
        }
        catch (Exception e) {
            throw new OutRangeException((CharSequence)"Out of float range: |{} ~ {}|, current: {}", new Object[]{Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE), rawValue});
        }
    }

    private double getDoubleValue(String rawValue, BigDecimal base, BigDecimal multiple, byte decimal) {
        try {
            BigDecimal multiply = this.getLinearValue(multiple, rawValue, base);
            if (Double.isInfinite(multiply.doubleValue())) {
                throw new OutRangeException();
            }
            return ArithmeticUtil.round((double)multiply.doubleValue(), (int)decimal);
        }
        catch (Exception e) {
            throw new OutRangeException((CharSequence)"Out of double range: |{} ~ {}|, current: {}", new Object[]{Double.MIN_VALUE, Double.MAX_VALUE, rawValue});
        }
    }

    private boolean getBooleanValue(String rawValue) {
        return Boolean.parseBoolean(rawValue);
    }

    public static RValueBuilder builder() {
        return new RValueBuilder();
    }

    public DeviceBO getDevice() {
        return this.device;
    }

    public PointBO getPoint() {
        return this.point;
    }

    public String getValue() {
        return this.value;
    }

    public void setDevice(DeviceBO device) {
        this.device = device;
    }

    public void setPoint(PointBO point) {
        this.point = point;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public RValue() {
    }

    public RValue(DeviceBO device, PointBO point, String value) {
        this.device = device;
        this.point = point;
        this.value = value;
    }

    public static class RValueBuilder {
        private DeviceBO device;
        private PointBO point;
        private String value;

        RValueBuilder() {
        }

        public RValueBuilder device(DeviceBO device) {
            this.device = device;
            return this;
        }

        public RValueBuilder point(PointBO point) {
            this.point = point;
            return this;
        }

        public RValueBuilder value(String value) {
            this.value = value;
            return this;
        }

        public RValue build() {
            return new RValue(this.device, this.point, this.value);
        }

        public String toString() {
            return "RValue.RValueBuilder(device=" + String.valueOf((Object)this.device) + ", point=" + String.valueOf((Object)this.point) + ", value=" + this.value + ")";
        }
    }
}

