/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.driver.entity.bo;

import cn.hutool.core.text.CharSequenceUtil;
import io.github.pnoker.common.enums.AttributeTypeFlagEnum;
import io.github.pnoker.common.exception.EmptyException;
import io.github.pnoker.common.exception.TypeException;
import io.github.pnoker.common.exception.UnSupportException;
import java.io.Serializable;
import java.util.Objects;

public class AttributeBO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String value;
    private AttributeTypeFlagEnum type;

    public <T> T getValue(Class<T> clazz) {
        if (Objects.isNull(this.type)) {
            throw new UnSupportException((CharSequence)("Unsupported attribute type of " + String.valueOf(this.type)), new Object[0]);
        }
        if (CharSequenceUtil.isEmpty((CharSequence)this.value)) {
            throw new EmptyException((CharSequence)"Attribute value is empty", new Object[0]);
        }
        String message = "Attribute type is: {}, can't be cast to class: {}";
        return (T)(switch (this.type) {
            default -> throw new MatchException(null, null);
            case AttributeTypeFlagEnum.STRING -> {
                if (!clazz.equals(String.class)) {
                    throw new TypeException((CharSequence)"Attribute type is: {}, can't be cast to class: {}", new Object[]{this.type.getCode(), clazz.getName()});
                }
                yield this.value;
            }
            case AttributeTypeFlagEnum.BYTE -> {
                if (!clazz.equals(Byte.class)) {
                    throw new TypeException((CharSequence)"Attribute type is: {}, can't be cast to class: {}", new Object[]{this.type.getCode(), clazz.getName()});
                }
                yield Byte.valueOf(this.value);
            }
            case AttributeTypeFlagEnum.SHORT -> {
                if (!clazz.equals(Short.class)) {
                    throw new TypeException((CharSequence)"Attribute type is: {}, can't be cast to class: {}", new Object[]{this.type.getCode(), clazz.getName()});
                }
                yield Short.valueOf(this.value);
            }
            case AttributeTypeFlagEnum.INT -> {
                if (!clazz.equals(Integer.class)) {
                    throw new TypeException((CharSequence)"Attribute type is: {}, can't be cast to class: {}", new Object[]{this.type.getCode(), clazz.getName()});
                }
                yield Integer.valueOf(this.value);
            }
            case AttributeTypeFlagEnum.LONG -> {
                if (!clazz.equals(Long.class)) {
                    throw new TypeException((CharSequence)"Attribute type is: {}, can't be cast to class: {}", new Object[]{this.type.getCode(), clazz.getName()});
                }
                yield Long.valueOf(this.value);
            }
            case AttributeTypeFlagEnum.FLOAT -> {
                if (!clazz.equals(Float.class)) {
                    throw new TypeException((CharSequence)"Attribute type is: {}, can't be cast to class: {}", new Object[]{this.type.getCode(), clazz.getName()});
                }
                yield Float.valueOf(this.value);
            }
            case AttributeTypeFlagEnum.DOUBLE -> {
                if (!clazz.equals(Double.class)) {
                    throw new TypeException((CharSequence)"Attribute type is: {}, can't be cast to class: {}", new Object[]{this.type.getCode(), clazz.getName()});
                }
                yield Double.valueOf(this.value);
            }
            case AttributeTypeFlagEnum.BOOLEAN -> {
                if (!clazz.equals(Boolean.class)) {
                    throw new TypeException((CharSequence)"Attribute type is: {}, can't be cast to class: {}", new Object[]{this.type.getCode(), clazz.getName()});
                }
                yield Boolean.valueOf(this.value);
            }
        });
    }

    public static AttributeBOBuilder builder() {
        return new AttributeBOBuilder();
    }

    public String getValue() {
        return this.value;
    }

    public AttributeTypeFlagEnum getType() {
        return this.type;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setType(AttributeTypeFlagEnum type) {
        this.type = type;
    }

    public AttributeBO() {
    }

    public AttributeBO(String value, AttributeTypeFlagEnum type) {
        this.value = value;
        this.type = type;
    }

    public static class AttributeBOBuilder {
        private String value;
        private AttributeTypeFlagEnum type;

        AttributeBOBuilder() {
        }

        public AttributeBOBuilder value(String value) {
            this.value = value;
            return this;
        }

        public AttributeBOBuilder type(AttributeTypeFlagEnum type) {
            this.type = type;
            return this;
        }

        public AttributeBO build() {
            return new AttributeBO(this.value, this.type);
        }

        public String toString() {
            return "AttributeBO.AttributeBOBuilder(value=" + this.value + ", type=" + String.valueOf(this.type) + ")";
        }
    }
}

