/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.driver.job;

import io.github.pnoker.common.driver.metadata.DriverMetadata;
import io.github.pnoker.common.driver.service.DriverSenderService;
import io.github.pnoker.common.entity.dto.DriverEventDTO;
import io.github.pnoker.common.enums.DriverEventTypeEnum;
import io.github.pnoker.common.utils.JsonUtil;
import jakarta.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.stereotype.Component;

@Component
public class DriverStatusScheduleJob
extends QuartzJobBean {
    private static final Logger log = LoggerFactory.getLogger(DriverStatusScheduleJob.class);
    @Resource
    DriverMetadata driverMetadata;
    @Resource
    private DriverSenderService driverSenderService;

    protected void executeInternal(@NotNull JobExecutionContext jobExecutionContext) {
        DriverEventDTO.DriverStatus driverStatus = new DriverEventDTO.DriverStatus(this.driverMetadata.getDriver().getId(), this.driverMetadata.getDriverStatus());
        DriverEventDTO driverEventDTO = new DriverEventDTO(DriverEventTypeEnum.HEARTBEAT, JsonUtil.toJsonString((Object)driverStatus));
        log.info("Report driver event: {}, event content: {}", (Object)driverEventDTO.getType().getCode(), (Object)JsonUtil.toJsonString((Object)driverEventDTO));
        this.driverSenderService.driverEventSender(driverEventDTO);
    }
}

