/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.driver.receiver.rabbit;

import com.rabbitmq.client.Channel;
import io.github.pnoker.common.driver.event.metadata.MetadataEventPublisher;
import io.github.pnoker.common.driver.metadata.DeviceMetadata;
import io.github.pnoker.common.driver.metadata.DriverMetadata;
import io.github.pnoker.common.driver.metadata.PointMetadata;
import io.github.pnoker.common.entity.dto.MetadataEventDTO;
import io.github.pnoker.common.entity.event.MetadataEvent;
import io.github.pnoker.common.enums.MetadataOperateTypeEnum;
import io.github.pnoker.common.enums.MetadataTypeEnum;
import io.github.pnoker.common.utils.JsonUtil;
import jakarta.annotation.Resource;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.stereotype.Component;

@Component
public class MetadataReceiver {
    private static final Logger log = LoggerFactory.getLogger(MetadataReceiver.class);
    @Resource
    PointMetadata pointMetadata;
    @Resource
    private DriverMetadata driverMetadata;
    @Resource
    private DeviceMetadata deviceMetadata;
    @Resource
    private MetadataEventPublisher metadataEventPublisher;

    @RabbitHandler
    @RabbitListener(queues={"#{metadataQueue.name}"})
    public void metadataReceive(Channel channel, Message message, MetadataEventDTO entityDTO) {
        try {
            channel.basicAck(message.getMessageProperties().getDeliveryTag(), true);
            log.info("Receive driver metadata: {}", (Object)JsonUtil.toJsonString((Object)entityDTO));
            if (Objects.isNull(entityDTO) || Objects.isNull(entityDTO.getMetadataType()) || Objects.isNull(entityDTO.getOperateType())) {
                log.error("Invalid driver metadata: {}", (Object)entityDTO);
                return;
            }
            if (MetadataTypeEnum.DEVICE.equals((Object)entityDTO.getMetadataType())) {
                if (MetadataOperateTypeEnum.ADD.equals((Object)entityDTO.getOperateType()) || MetadataOperateTypeEnum.UPDATE.equals((Object)entityDTO.getOperateType())) {
                    log.info("Upsert device: {}", (Object)entityDTO.getId());
                    this.deviceMetadata.loadCache(entityDTO.getId());
                    this.driverMetadata.getDeviceIds().add(entityDTO.getId());
                } else if (MetadataOperateTypeEnum.DELETE.equals((Object)entityDTO.getOperateType())) {
                    log.info("Delete device: {}", (Object)entityDTO.getId());
                    this.deviceMetadata.removeCache(entityDTO.getId());
                    this.driverMetadata.getDeviceIds().remove(entityDTO.getId());
                }
                this.metadataEventPublisher.publishEvent(new MetadataEvent((Object)this, entityDTO.getId(), MetadataTypeEnum.DEVICE, entityDTO.getOperateType()));
            } else if (MetadataTypeEnum.POINT.equals((Object)entityDTO.getMetadataType())) {
                if (MetadataOperateTypeEnum.ADD.equals((Object)entityDTO.getOperateType()) || MetadataOperateTypeEnum.UPDATE.equals((Object)entityDTO.getOperateType())) {
                    log.info("Upsert point: {}", (Object)entityDTO.getId());
                    this.pointMetadata.loadCache(entityDTO.getId());
                } else if (MetadataOperateTypeEnum.DELETE.equals((Object)entityDTO.getOperateType())) {
                    log.info("Delete point: {}", (Object)entityDTO.getId());
                    this.pointMetadata.removeCache(entityDTO.getId());
                }
                this.metadataEventPublisher.publishEvent(new MetadataEvent((Object)this, entityDTO.getId(), MetadataTypeEnum.POINT, entityDTO.getOperateType()));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

