/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.driver.service.impl;

import io.github.pnoker.common.driver.entity.bean.PointValue;
import io.github.pnoker.common.driver.entity.bean.RValue;
import io.github.pnoker.common.driver.entity.bo.AttributeBO;
import io.github.pnoker.common.driver.entity.bo.DeviceBO;
import io.github.pnoker.common.driver.entity.bo.PointBO;
import io.github.pnoker.common.driver.metadata.DeviceMetadata;
import io.github.pnoker.common.driver.metadata.PointMetadata;
import io.github.pnoker.common.driver.service.DriverCustomService;
import io.github.pnoker.common.driver.service.DriverReadService;
import io.github.pnoker.common.driver.service.DriverSenderService;
import io.github.pnoker.common.entity.dto.DeviceCommandDTO;
import io.github.pnoker.common.exception.ReadPointException;
import io.github.pnoker.common.utils.JsonUtil;
import jakarta.annotation.Resource;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DriverReadServiceImpl
implements DriverReadService {
    private static final Logger log = LoggerFactory.getLogger(DriverReadServiceImpl.class);
    @Resource
    private DeviceMetadata deviceMetadata;
    @Resource
    private PointMetadata pointMetadata;
    @Resource
    private DriverSenderService driverSenderService;
    @Resource
    private DriverCustomService driverCustomService;

    @Override
    public void read(Long deviceId, Long pointId) {
        DeviceBO device = this.deviceMetadata.getCache(deviceId);
        if (Objects.isNull((Object)device)) {
            throw new ReadPointException((CharSequence)"Failed to read point value, device[{}] is null", new Object[]{deviceId});
        }
        if (!device.getPointIds().contains(pointId)) {
            throw new ReadPointException((CharSequence)"Failed to read point value, device[{}] not contained point[{}]", new Object[]{deviceId, pointId});
        }
        Map<String, AttributeBO> driverConfig = this.deviceMetadata.getDriverConfig(deviceId);
        Map<String, AttributeBO> pointConfig = this.deviceMetadata.getPointConfig(deviceId, pointId);
        PointBO point = this.pointMetadata.getCache(pointId);
        if (Objects.isNull((Object)point)) {
            throw new ReadPointException((CharSequence)("Failed to read point value, point[{}] is null" + deviceId), new Object[0]);
        }
        RValue rValue = this.driverCustomService.read(driverConfig, pointConfig, device, point);
        if (Objects.isNull(rValue)) {
            throw new ReadPointException((CharSequence)"Failed to read point value, point value is null", new Object[0]);
        }
        this.driverSenderService.pointValueSender(new PointValue(rValue));
    }

    @Override
    public void read(DeviceCommandDTO commandDTO) {
        DeviceCommandDTO.DeviceRead deviceRead = (DeviceCommandDTO.DeviceRead)JsonUtil.parseObject((String)commandDTO.getContent(), DeviceCommandDTO.DeviceRead.class);
        if (Objects.isNull(deviceRead)) {
            return;
        }
        log.info("Start command of read: {}", (Object)JsonUtil.toJsonString((Object)commandDTO));
        this.read(deviceRead.getDeviceId(), deviceRead.getPointId());
        log.info("End command of read");
    }
}

