/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.driver.service.impl;

import io.github.pnoker.common.driver.entity.bo.DriverBO;
import io.github.pnoker.common.driver.entity.bo.RegisterBO;
import io.github.pnoker.common.driver.entity.property.DriverProperty;
import io.github.pnoker.common.driver.grpc.client.DriverClient;
import io.github.pnoker.common.driver.service.DriverRegisterService;
import io.github.pnoker.common.utils.JsonUtil;
import jakarta.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DriverRegisterServiceImpl
implements DriverRegisterService {
    private static final Logger log = LoggerFactory.getLogger(DriverRegisterServiceImpl.class);
    @Resource
    private DriverProperty driverProperty;
    @Resource
    private DriverClient driverClient;

    @Override
    public void initial() {
        try {
            RegisterBO entityBO = this.buildRegisterBOByProperty();
            log.info("The driver information is: {}", (Object)JsonUtil.toJsonString((Object)entityBO));
            this.driverClient.driverRegister(entityBO);
        }
        catch (Exception e) {
            log.error("Driver initialization failed: {}", (Object)e.getMessage(), (Object)e);
            System.exit(1);
        }
    }

    private RegisterBO buildRegisterBOByProperty() {
        DriverBO driverBO = new DriverBO();
        driverBO.setDriverName(this.driverProperty.getName());
        driverBO.setDriverCode(this.driverProperty.getCode());
        driverBO.setServiceName(this.driverProperty.getService());
        driverBO.setServiceHost(this.driverProperty.getHost());
        driverBO.setDriverTypeFlag(this.driverProperty.getType());
        driverBO.setRemark(this.driverProperty.getRemark());
        RegisterBO entityBO = new RegisterBO();
        entityBO.setDriver(driverBO);
        entityBO.setTenant(this.driverProperty.getTenant());
        entityBO.setClient(this.driverProperty.getClient());
        entityBO.setDriverAttributes(this.driverProperty.getDriverAttribute());
        entityBO.setPointAttributes(this.driverProperty.getPointAttribute());
        return entityBO;
    }
}

