/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.driver.service.impl;

import io.github.pnoker.common.constant.driver.RabbitConstant;
import io.github.pnoker.common.driver.entity.bean.PointValue;
import io.github.pnoker.common.driver.entity.property.DriverProperty;
import io.github.pnoker.common.driver.service.DriverSenderService;
import io.github.pnoker.common.entity.dto.DeviceEventDTO;
import io.github.pnoker.common.entity.dto.DriverEventDTO;
import io.github.pnoker.common.enums.DeviceEventTypeEnum;
import io.github.pnoker.common.enums.DeviceStatusEnum;
import io.github.pnoker.common.utils.JsonUtil;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.stereotype.Service;

@Service
public class DriverSenderServiceImpl
implements DriverSenderService {
    private static final Logger log = LoggerFactory.getLogger(DriverSenderServiceImpl.class);
    private final DriverProperty driverProperty;
    private final RabbitTemplate rabbitTemplate;

    public DriverSenderServiceImpl(DriverProperty driverProperty, RabbitTemplate rabbitTemplate) {
        this.driverProperty = driverProperty;
        this.rabbitTemplate = rabbitTemplate;
    }

    @Override
    public void driverEventSender(DriverEventDTO entityDTO) {
        if (Objects.isNull(entityDTO)) {
            return;
        }
        this.rabbitTemplate.convertAndSend(RabbitConstant.TOPIC_EXCHANGE_EVENT, "dc3.r.event.driver." + this.driverProperty.getService(), (Object)entityDTO);
    }

    @Override
    public void deviceEventSender(DeviceEventDTO entityDTO) {
        if (!Objects.nonNull(entityDTO)) {
            return;
        }
        this.rabbitTemplate.convertAndSend(RabbitConstant.TOPIC_EXCHANGE_EVENT, "dc3.r.event.device." + this.driverProperty.getService(), (Object)entityDTO);
    }

    @Override
    public void deviceStatusSender(Long deviceId, DeviceStatusEnum status) {
        this.sendDeviceStatus(deviceId, status, 15, TimeUnit.MINUTES);
    }

    @Override
    public void deviceStatusSender(Long deviceId, DeviceStatusEnum status, int timeOut, TimeUnit timeUnit) {
        this.sendDeviceStatus(deviceId, status, timeOut, timeUnit);
    }

    @Override
    public void pointValueSender(PointValue entityDTO) {
        if (Objects.nonNull(entityDTO)) {
            log.info("Send point value: {}", (Object)JsonUtil.toJsonString((Object)entityDTO));
            this.rabbitTemplate.convertAndSend(RabbitConstant.TOPIC_EXCHANGE_VALUE, "dc3.r.value.point." + this.driverProperty.getService(), (Object)entityDTO);
        }
    }

    @Override
    public void pointValueSender(List<PointValue> entityDTOList) {
        if (Objects.nonNull(entityDTOList)) {
            entityDTOList.forEach(this::pointValueSender);
        }
    }

    private void sendDeviceStatus(Long deviceId, DeviceStatusEnum status, int timeOut, TimeUnit timeUnit) {
        DeviceEventDTO.DeviceStatus deviceStatus = new DeviceEventDTO.DeviceStatus(deviceId, status, timeOut, timeUnit);
        DeviceEventDTO deviceEventDTO = new DeviceEventDTO(DeviceEventTypeEnum.HEARTBEAT, JsonUtil.toJsonString((Object)deviceStatus));
        log.info("Report device event: {}, event content: {}", (Object)deviceEventDTO.getType().getCode(), (Object)JsonUtil.toJsonString((Object)deviceEventDTO));
        this.deviceEventSender(deviceEventDTO);
    }
}

