/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.driver.service.impl;

import io.github.pnoker.common.driver.entity.bean.WValue;
import io.github.pnoker.common.driver.entity.bo.AttributeBO;
import io.github.pnoker.common.driver.entity.bo.DeviceBO;
import io.github.pnoker.common.driver.entity.bo.PointBO;
import io.github.pnoker.common.driver.metadata.DeviceMetadata;
import io.github.pnoker.common.driver.metadata.DriverMetadata;
import io.github.pnoker.common.driver.metadata.PointMetadata;
import io.github.pnoker.common.driver.service.DriverCustomService;
import io.github.pnoker.common.driver.service.DriverWriteService;
import io.github.pnoker.common.entity.dto.DeviceCommandDTO;
import io.github.pnoker.common.exception.ReadPointException;
import io.github.pnoker.common.exception.ServiceException;
import io.github.pnoker.common.utils.JsonUtil;
import jakarta.annotation.Resource;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DriverWriteServiceImpl
implements DriverWriteService {
    private static final Logger log = LoggerFactory.getLogger(DriverWriteServiceImpl.class);
    @Resource
    private DriverMetadata driverMetadata;
    @Resource
    private DeviceMetadata deviceMetadata;
    @Resource
    private PointMetadata pointMetadata;
    @Resource
    private DriverCustomService driverCustomService;

    @Override
    public void write(Long deviceId, Long pointId, String value) {
        try {
            DeviceBO device = this.deviceMetadata.getCache(deviceId);
            if (Objects.isNull((Object)device)) {
                throw new ReadPointException((CharSequence)"Failed to write point value, device[{}] is null", new Object[]{deviceId});
            }
            if (!device.getPointIds().contains(pointId)) {
                throw new ReadPointException((CharSequence)"Failed to write point value, device[{}] not contained point[{}]", new Object[]{deviceId, pointId});
            }
            Map<String, AttributeBO> driverConfig = this.deviceMetadata.getDriverConfig(deviceId);
            Map<String, AttributeBO> pointConfig = this.deviceMetadata.getPointConfig(deviceId, pointId);
            PointBO point = this.pointMetadata.getCache(pointId);
            if (Objects.isNull((Object)point)) {
                throw new ReadPointException((CharSequence)("Failed to write point value, point[{}] is null" + deviceId), new Object[0]);
            }
            this.driverCustomService.write(driverConfig, pointConfig, device, point, new WValue(value, point.getPointTypeFlag()));
        }
        catch (Exception e) {
            throw new ServiceException((CharSequence)e.getMessage(), new Object[0]);
        }
    }

    @Override
    public void write(DeviceCommandDTO commandDTO) {
        DeviceCommandDTO.DeviceWrite deviceWrite = (DeviceCommandDTO.DeviceWrite)JsonUtil.parseObject((String)commandDTO.getContent(), DeviceCommandDTO.DeviceWrite.class);
        if (Objects.isNull(deviceWrite)) {
            return;
        }
        log.info("Start command of write: {}", (Object)JsonUtil.toJsonString((Object)commandDTO));
        this.write(deviceWrite.getDeviceId(), deviceWrite.getPointId(), deviceWrite.getValue());
        log.info("End command of write: write");
    }
}

