/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.entity.builder;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.github.pnoker.common.entity.bo.DictionaryBO;
import io.github.pnoker.common.entity.builder.DictionaryBuilder;
import io.github.pnoker.common.entity.vo.DictionaryVO;
import io.github.pnoker.common.utils.MapStructUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class DictionaryBuilderImpl
implements DictionaryBuilder {
    @Override
    public DictionaryBO buildBOByVO(DictionaryVO entityVO) {
        if (entityVO == null) {
            return null;
        }
        DictionaryBO.DictionaryBOBuilder dictionaryBO = DictionaryBO.builder();
        if (MapStructUtil.isNotEmpty((String)entityVO.getType())) {
            dictionaryBO.type(entityVO.getType());
        }
        if (MapStructUtil.isNotEmpty((String)entityVO.getLabel())) {
            dictionaryBO.label(entityVO.getLabel());
        }
        if (MapStructUtil.isNotEmpty((String)entityVO.getValue())) {
            dictionaryBO.value(entityVO.getValue());
        }
        dictionaryBO.disabled(entityVO.isDisabled());
        dictionaryBO.expand(entityVO.isExpand());
        dictionaryBO.children(this.buildBOListByVOList(entityVO.getChildren()));
        return dictionaryBO.build();
    }

    @Override
    public List<DictionaryBO> buildBOListByVOList(List<DictionaryVO> entityVOList) {
        if (entityVOList == null) {
            return null;
        }
        ArrayList<DictionaryBO> list = new ArrayList<DictionaryBO>(entityVOList.size());
        for (DictionaryVO dictionaryVO : entityVOList) {
            list.add(this.buildBOByVO(dictionaryVO));
        }
        return list;
    }

    @Override
    public DictionaryVO buildVOByBO(DictionaryBO entityBO) {
        if (entityBO == null) {
            return null;
        }
        DictionaryVO.DictionaryVOBuilder dictionaryVO = DictionaryVO.builder();
        if (MapStructUtil.isNotEmpty((String)entityBO.getType())) {
            dictionaryVO.type(entityBO.getType());
        }
        if (MapStructUtil.isNotEmpty((String)entityBO.getLabel())) {
            dictionaryVO.label(entityBO.getLabel());
        }
        if (MapStructUtil.isNotEmpty((String)entityBO.getValue())) {
            dictionaryVO.value(entityBO.getValue());
        }
        dictionaryVO.disabled(entityBO.isDisabled());
        dictionaryVO.expand(entityBO.isExpand());
        dictionaryVO.children(this.buildVOListByBOList(entityBO.getChildren()));
        return dictionaryVO.build();
    }

    @Override
    public List<DictionaryVO> buildVOListByBOList(List<DictionaryBO> entityBOList) {
        if (entityBOList == null) {
            return null;
        }
        ArrayList<DictionaryVO> list = new ArrayList<DictionaryVO>(entityBOList.size());
        for (DictionaryBO dictionaryBO : entityBOList) {
            list.add(this.buildVOByBO(dictionaryBO));
        }
        return list;
    }

    @Override
    public Page<DictionaryVO> buildVOPageByBOPage(Page<DictionaryBO> entityPageBO) {
        if (entityPageBO == null) {
            return null;
        }
        Page page = new Page();
        if (MapStructUtil.isValidNumber((Number)entityPageBO.getPages())) {
            page.setPages(entityPageBO.getPages());
        }
        page.setRecords(this.buildVOListByBOList(entityPageBO.getRecords()));
        if (MapStructUtil.isValidNumber((Number)entityPageBO.getTotal())) {
            page.setTotal(entityPageBO.getTotal());
        }
        if (MapStructUtil.isValidNumber((Number)entityPageBO.getSize())) {
            page.setSize(entityPageBO.getSize());
        }
        if (MapStructUtil.isValidNumber((Number)entityPageBO.getCurrent())) {
            page.setCurrent(entityPageBO.getCurrent());
        }
        return page;
    }
}

