/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.entity.dto;

import io.github.pnoker.common.enums.DeviceCommandTypeEnum;
import java.io.Serializable;
import java.time.LocalDateTime;

public class DeviceCommandDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DeviceCommandTypeEnum type;
    private String content;
    private LocalDateTime createTime;

    public DeviceCommandDTO(DeviceCommandTypeEnum type, String content) {
        this.type = type;
        this.content = content;
        this.createTime = LocalDateTime.now();
    }

    public static DeviceCommandDTOBuilder builder() {
        return new DeviceCommandDTOBuilder();
    }

    public DeviceCommandTypeEnum getType() {
        return this.type;
    }

    public String getContent() {
        return this.content;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public void setType(DeviceCommandTypeEnum type) {
        this.type = type;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public DeviceCommandDTO() {
    }

    public DeviceCommandDTO(DeviceCommandTypeEnum type, String content, LocalDateTime createTime) {
        this.type = type;
        this.content = content;
        this.createTime = createTime;
    }

    public static class DeviceCommandDTOBuilder {
        private DeviceCommandTypeEnum type;
        private String content;
        private LocalDateTime createTime;

        DeviceCommandDTOBuilder() {
        }

        public DeviceCommandDTOBuilder type(DeviceCommandTypeEnum type) {
            this.type = type;
            return this;
        }

        public DeviceCommandDTOBuilder content(String content) {
            this.content = content;
            return this;
        }

        public DeviceCommandDTOBuilder createTime(LocalDateTime createTime) {
            this.createTime = createTime;
            return this;
        }

        public DeviceCommandDTO build() {
            return new DeviceCommandDTO(this.type, this.content, this.createTime);
        }

        public String toString() {
            return "DeviceCommandDTO.DeviceCommandDTOBuilder(type=" + String.valueOf(this.type) + ", content=" + this.content + ", createTime=" + String.valueOf(this.createTime) + ")";
        }
    }

    public static class DeviceWrite
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Long deviceId;
        private Long pointId;
        private String value;
        private LocalDateTime createTime;

        public DeviceWrite(Long deviceId, Long pointId, String value) {
            this.deviceId = deviceId;
            this.pointId = pointId;
            this.value = value;
            this.createTime = LocalDateTime.now();
        }

        public Long getDeviceId() {
            return this.deviceId;
        }

        public Long getPointId() {
            return this.pointId;
        }

        public String getValue() {
            return this.value;
        }

        public LocalDateTime getCreateTime() {
            return this.createTime;
        }

        public void setDeviceId(Long deviceId) {
            this.deviceId = deviceId;
        }

        public void setPointId(Long pointId) {
            this.pointId = pointId;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setCreateTime(LocalDateTime createTime) {
            this.createTime = createTime;
        }

        public DeviceWrite() {
        }

        public DeviceWrite(Long deviceId, Long pointId, String value, LocalDateTime createTime) {
            this.deviceId = deviceId;
            this.pointId = pointId;
            this.value = value;
            this.createTime = createTime;
        }
    }

    public static class DeviceRead
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Long deviceId;
        private Long pointId;
        private LocalDateTime createTime;

        public DeviceRead(Long deviceId, Long pointId) {
            this.deviceId = deviceId;
            this.pointId = pointId;
            this.createTime = LocalDateTime.now();
        }

        public Long getDeviceId() {
            return this.deviceId;
        }

        public Long getPointId() {
            return this.pointId;
        }

        public LocalDateTime getCreateTime() {
            return this.createTime;
        }

        public void setDeviceId(Long deviceId) {
            this.deviceId = deviceId;
        }

        public void setPointId(Long pointId) {
            this.pointId = pointId;
        }

        public void setCreateTime(LocalDateTime createTime) {
            this.createTime = createTime;
        }

        public DeviceRead() {
        }

        public DeviceRead(Long deviceId, Long pointId, LocalDateTime createTime) {
            this.deviceId = deviceId;
            this.pointId = pointId;
            this.createTime = createTime;
        }
    }
}

