/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.mqtt.entity.property;

import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(prefix="driver.mqtt")
public class MqttProperties {
    @NotBlank(message="Url can't be empty, ssl://host:port")
    private @NotBlank(message="Url can't be empty, ssl://host:port") String url;
    @NotNull(message="Auth type can't be empty")
    private @NotNull(message="Auth type can't be empty") AuthTypeEnum authType = AuthTypeEnum.NONE;
    private String username;
    private String password;
    private String caCrt = "classpath:/certs/ca.crt";
    private String clientKeyPass = "dc3-client";
    private String clientKey = "classpath:/certs/client.key";
    private String clientCrt = "classpath:/certs/client.crt";
    @NotBlank(message="Client name can't be empty")
    private @NotBlank(message="Client name can't be empty") String client;
    @NotBlank(message="Topic prefix name can't be empty")
    private @NotBlank(message="Topic prefix name can't be empty") String topicPrefix;
    @NotNull(message="Default topic can't be empty")
    private @NotNull(message="Default topic can't be empty") Topic defaultSendTopic = new Topic("dc3/d/v/dc3-driver-mqtt_default", 2);
    @Size(min=1, message="Receive topic at least one topic")
    private @Size(min=1, message="Receive topic at least one topic") List<Topic> receiveTopics;
    @NotNull(message="Keep alive interval can't be empty")
    private @NotNull(message="Keep alive interval can't be empty") Integer keepAlive = 15;
    @NotNull(message="Completion timeout can't be empty")
    private @NotNull(message="Completion timeout can't be empty") Integer completionTimeout = 3000;

    public String getUrl() {
        return this.url;
    }

    public AuthTypeEnum getAuthType() {
        return this.authType;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCaCrt() {
        return this.caCrt;
    }

    public String getClientKeyPass() {
        return this.clientKeyPass;
    }

    public String getClientKey() {
        return this.clientKey;
    }

    public String getClientCrt() {
        return this.clientCrt;
    }

    public String getClient() {
        return this.client;
    }

    public String getTopicPrefix() {
        return this.topicPrefix;
    }

    public Topic getDefaultSendTopic() {
        return this.defaultSendTopic;
    }

    public List<Topic> getReceiveTopics() {
        return this.receiveTopics;
    }

    public Integer getKeepAlive() {
        return this.keepAlive;
    }

    public Integer getCompletionTimeout() {
        return this.completionTimeout;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setAuthType(AuthTypeEnum authType) {
        this.authType = authType;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setCaCrt(String caCrt) {
        this.caCrt = caCrt;
    }

    public void setClientKeyPass(String clientKeyPass) {
        this.clientKeyPass = clientKeyPass;
    }

    public void setClientKey(String clientKey) {
        this.clientKey = clientKey;
    }

    public void setClientCrt(String clientCrt) {
        this.clientCrt = clientCrt;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public void setTopicPrefix(String topicPrefix) {
        this.topicPrefix = topicPrefix;
    }

    public void setDefaultSendTopic(Topic defaultSendTopic) {
        this.defaultSendTopic = defaultSendTopic;
    }

    public void setReceiveTopics(List<Topic> receiveTopics) {
        this.receiveTopics = receiveTopics;
    }

    public void setKeepAlive(Integer keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setCompletionTimeout(Integer completionTimeout) {
        this.completionTimeout = completionTimeout;
    }

    public static enum AuthTypeEnum {
        NONE,
        CLIENT_ID,
        USERNAME,
        X509;

    }

    public static class Topic {
        @NotBlank(message="Topic name can't be empty")
        private @NotBlank(message="Topic name can't be empty") String name;
        @Min(value=0L)
        @Max(value=2L)
        private @Min(value=0L) @Max(value=2L) Integer qos;

        public String getName() {
            return this.name;
        }

        public Integer getQos() {
            return this.qos;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setQos(Integer qos) {
            this.qos = qos;
        }

        public Topic() {
        }

        public Topic(String name, Integer qos) {
            this.name = name;
            this.qos = qos;
        }
    }
}

