/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.mqtt.service.impl;

import io.github.pnoker.common.mqtt.service.MqttScheduleService;
import io.github.pnoker.common.mqtt.service.job.MqttScheduleJob;
import io.github.pnoker.common.quartz.QuartzService;
import jakarta.annotation.Resource;
import org.quartz.DateBuilder;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MqttScheduleServiceImpl
implements MqttScheduleService {
    private static final Logger log = LoggerFactory.getLogger(MqttScheduleServiceImpl.class);
    @Value(value="${driver.mqtt.batch.interval}")
    private Integer interval;
    @Resource
    private QuartzService quartzService;

    @Override
    public void initial() {
        try {
            this.quartzService.createJobWithInterval("ScheduleGroup", "MqttScheduleJob", this.interval, DateBuilder.IntervalUnit.SECOND, MqttScheduleJob.class);
            this.quartzService.startScheduler();
        }
        catch (SchedulerException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

