/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.utils;

import cn.hutool.core.text.CharSequenceUtil;
import io.github.pnoker.common.mqtt.entity.property.MqttProperties;
import io.github.pnoker.common.utils.X509Util;
import javax.net.SocketFactory;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;

public class MqttUtil {
    private MqttUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static MqttConnectOptions getMqttConnectOptions(MqttProperties mqttProperties) {
        MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
        if (MqttProperties.AuthTypeEnum.USERNAME.equals((Object)mqttProperties.getAuthType()) || MqttProperties.AuthTypeEnum.X509.equals((Object)mqttProperties.getAuthType())) {
            if (CharSequenceUtil.isNotEmpty((CharSequence)mqttProperties.getUsername())) {
                mqttConnectOptions.setUserName(mqttProperties.getUsername());
            }
            if (CharSequenceUtil.isNotEmpty((CharSequence)mqttProperties.getPassword())) {
                mqttConnectOptions.setPassword(mqttProperties.getPassword().toCharArray());
            }
        }
        if (MqttProperties.AuthTypeEnum.X509.equals((Object)mqttProperties.getAuthType())) {
            mqttConnectOptions.setSocketFactory((SocketFactory)X509Util.getSSLSocketFactory((String)mqttProperties.getCaCrt(), (String)mqttProperties.getClientCrt(), (String)mqttProperties.getClientKey(), (String)(CharSequenceUtil.isEmpty((CharSequence)mqttProperties.getClientKeyPass()) ? "" : mqttProperties.getClientKeyPass())));
        }
        mqttConnectOptions.setHttpsHostnameVerificationEnabled(false);
        mqttConnectOptions.setServerURIs(new String[]{mqttProperties.getUrl()});
        mqttConnectOptions.setKeepAliveInterval(mqttProperties.getKeepAlive().intValue());
        return mqttConnectOptions;
    }
}

