/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.prometheus.dashboard.rabbitmq.controller;

import io.github.pnoker.common.entity.R;
import io.github.pnoker.common.prometheus.dashboard.rabbitmq.entity.vo.RabbitMQClusterVo;
import io.github.pnoker.common.prometheus.dashboard.rabbitmq.service.RabbitMQClusterService;
import jakarta.annotation.Resource;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/rabbitmq/cluster"})
public class RabbitMQClusterController {
    private static final Logger log = LoggerFactory.getLogger(RabbitMQClusterController.class);
    @Resource
    private RabbitMQClusterService rabbitMQClusterService;

    @GetMapping(value={"/clusters"})
    public Mono<R<List<RabbitMQClusterVo>>> queryCluster() {
        try {
            List<RabbitMQClusterVo> rabbbit = this.rabbitMQClusterService.queryCluster();
            if (rabbbit != null) {
                return Mono.just((Object)R.ok(rabbbit));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Mono.just((Object)R.fail((String)e.getMessage()));
        }
        return Mono.just((Object)R.fail());
    }
}

