/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.prometheus.dashboard.rabbitmq.controller;

import io.github.pnoker.common.entity.R;
import io.github.pnoker.common.prometheus.dashboard.rabbitmq.entity.vo.RabbitMQDataVo;
import io.github.pnoker.common.prometheus.dashboard.rabbitmq.service.RabbitMQConnectionService;
import io.github.pnoker.common.prometheus.service.PrometheusService;
import jakarta.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/rabbitmq/connection"})
public class RabbitMQConnectionController {
    private static final Logger log = LoggerFactory.getLogger(RabbitMQConnectionController.class);
    @Resource
    private PrometheusService prometheusService;
    @Resource
    private RabbitMQConnectionService rabbitMQConnectionService;

    @GetMapping(value={"/connections"})
    public Mono<R<RabbitMQDataVo>> queryConns(@RequestParam String cluster) {
        try {
            RabbitMQDataVo rabbbit = this.rabbitMQConnectionService.queryConn(cluster);
            if (!rabbbit.getTimes().isEmpty() && !rabbbit.getValues().isEmpty()) {
                return Mono.just((Object)R.ok((Object)rabbbit));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Mono.just((Object)R.fail((String)e.getMessage()));
        }
        return Mono.just((Object)R.fail());
    }
}

