/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.prometheus.dashboard.rabbitmq.controller;

import io.github.pnoker.common.entity.R;
import io.github.pnoker.common.prometheus.dashboard.rabbitmq.entity.vo.RabbitMQDataVo;
import io.github.pnoker.common.prometheus.dashboard.rabbitmq.entity.vo.RabbitMQNodeVo;
import io.github.pnoker.common.prometheus.dashboard.rabbitmq.service.RabbitMQNodeService;
import jakarta.annotation.Resource;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/rabbitmq/node"})
public class RabbitMQNodeController {
    private static final Logger log = LoggerFactory.getLogger(RabbitMQNodeController.class);
    @Resource
    private RabbitMQNodeService rabbitMQNodeService;

    @GetMapping(value={"/nodes"})
    public Mono<R<RabbitMQDataVo>> queryNodes(@RequestParam String cluster) {
        try {
            RabbitMQDataVo rabbbit = this.rabbitMQNodeService.queryNode(cluster);
            if (!rabbbit.getTimes().isEmpty() && !rabbbit.getValues().isEmpty()) {
                return Mono.just((Object)R.ok((Object)rabbbit));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Mono.just((Object)R.fail((String)e.getMessage()));
        }
        return Mono.just((Object)R.fail());
    }

    @GetMapping(value={"/nodes_table"})
    public Mono<R<List<RabbitMQNodeVo>>> queryNodesTable(@RequestParam String cluster) {
        try {
            List<RabbitMQNodeVo> rabbbit = this.rabbitMQNodeService.queryNodeTable(cluster);
            if (rabbbit != null) {
                return Mono.just((Object)R.ok(rabbbit));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Mono.just((Object)R.fail((String)e.getMessage()));
        }
        return Mono.just((Object)R.fail());
    }
}

