/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.prometheus.dashboard.rabbitmq.service.impl;

import cn.hutool.core.map.MapBuilder;
import cn.hutool.core.map.MapUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.pnoker.common.prometheus.dashboard.rabbitmq.entity.vo.RabbitMQClusterVo;
import io.github.pnoker.common.prometheus.dashboard.rabbitmq.service.RabbitMQClusterService;
import io.github.pnoker.common.prometheus.service.PrometheusService;
import jakarta.annotation.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class RabbitMQClusterServiceImpl
implements RabbitMQClusterService {
    @Resource
    private PrometheusService prometheusService;

    @Override
    public List<RabbitMQClusterVo> queryCluster() {
        try {
            MapBuilder builder = MapUtil.builder();
            builder.put((Object)"query", (Object)"rabbitmq_identity_info{namespace=''}");
            String jsonResponse = this.prometheusService.query(builder.build());
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode rootNode = objectMapper.readTree(jsonResponse);
            int n = rootNode.path("data").path("result").size();
            ArrayList<RabbitMQClusterVo> clusters = new ArrayList<RabbitMQClusterVo>();
            for (int i = 0; i < n; ++i) {
                RabbitMQClusterVo cluster = new RabbitMQClusterVo();
                JsonNode metricNode = rootNode.path("data").path("result").get(i).path("metric");
                String str = metricNode.path("rabbitmq_cluster").asText();
                cluster.setOriginal(str);
                if (str.contains("rabbit")) {
                    cluster.setDisplay(str.replace("rabbit", ""));
                } else {
                    cluster.setDisplay(str);
                }
                clusters.add(cluster);
            }
            return clusters;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

