/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.prometheus.dashboard.rabbitmq.service.impl;

import cn.hutool.core.map.MapBuilder;
import cn.hutool.core.map.MapUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.pnoker.common.prometheus.dashboard.rabbitmq.entity.vo.RabbitMQDataVo;
import io.github.pnoker.common.prometheus.dashboard.rabbitmq.entity.vo.RabbitMQNodeVo;
import io.github.pnoker.common.prometheus.dashboard.rabbitmq.service.RabbitMQNodeService;
import io.github.pnoker.common.prometheus.service.PrometheusService;
import jakarta.annotation.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class RabbitMQNodeServiceImpl
implements RabbitMQNodeService {
    @Resource
    private PrometheusService prometheusService;

    @Override
    public RabbitMQDataVo queryNode(String cluster) {
        try {
            String promQLQuery = "sum(rabbitmq_build_info * on(instance) group_left(rabbitmq_cluster) rabbitmq_identity_info{rabbitmq_cluster='" + cluster + "', namespace=''})";
            MapBuilder builder = MapUtil.builder();
            builder.put((Object)"query", (Object)promQLQuery);
            String jsonResponse = this.prometheusService.queryRange(builder.build());
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode rootNode = objectMapper.readTree(jsonResponse);
            JsonNode resultNode = rootNode.path("data").path("result").get(0);
            ArrayList<Double> values = new ArrayList<Double>();
            ArrayList<Long> times = new ArrayList<Long>();
            for (int i = 0; i < 61; ++i) {
                long time = resultNode.path("values").get(i).get(0).asLong();
                times.add(time);
                Double ivalue = resultNode.path("values").get(i).get(1).asDouble();
                values.add(ivalue);
            }
            RabbitMQDataVo rabbitMQDataVo = new RabbitMQDataVo();
            rabbitMQDataVo.setTimes(times);
            rabbitMQDataVo.setValues(values);
            return rabbitMQDataVo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<RabbitMQNodeVo> queryNodeTable(String cluster) {
        try {
            String promQLQuery = "rabbitmq_build_info * on(instance) group_left(rabbitmq_cluster, rabbitmq_node) rabbitmq_identity_info{rabbitmq_cluster='" + cluster + "', namespace=''}";
            MapBuilder builder = MapUtil.builder();
            builder.put((Object)"query", (Object)promQLQuery);
            String jsonResponse = this.prometheusService.query(builder.build());
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode rootNode = objectMapper.readTree(jsonResponse);
            int n = rootNode.path("data").path("result").size();
            ArrayList<RabbitMQNodeVo> rabbitMQNodeVoList = new ArrayList<RabbitMQNodeVo>();
            for (int i = 0; i < n; ++i) {
                JsonNode metricNode = rootNode.path("data").path("result").get(i).path("metric");
                JsonNode valueNode = rootNode.path("data").path("result").get(i).path("value");
                RabbitMQNodeVo rabbitMQNodeVo = new RabbitMQNodeVo();
                RabbitMQNodeVo.Metric metric = new RabbitMQNodeVo.Metric();
                RabbitMQNodeVo.ValueItem valueItem = new RabbitMQNodeVo.ValueItem();
                metric.setErlangVersion(metricNode.path("erlang_version").asText());
                String instance = null;
                if (metricNode.path("instance").asText().contains("rabbit")) {
                    instance = metricNode.path("instance").asText().replace("rabbit", "");
                }
                metric.setInstance(instance);
                String job = null;
                if (metricNode.path("job").asText().contains("rabbit")) {
                    job = metricNode.path("job").asText().replace("rabbit", "");
                }
                metric.setJob(job);
                String rabbitmq_cluster = null;
                if (metricNode.path("rabbitmq_cluster").asText().contains("rabbit")) {
                    rabbitmq_cluster = metricNode.path("rabbitmq_cluster").asText().replace("rabbit", "");
                }
                metric.setRabbitmqCluster(rabbitmq_cluster);
                String rabbitmq_node = null;
                if (metricNode.path("rabbitmq_node").asText().contains("rabbit")) {
                    rabbitmq_node = metricNode.path("rabbitmq_node").asText().replace("rabbit", "");
                }
                metric.setRabbitmqNode(rabbitmq_node);
                metric.setRabbitmqVersion(metricNode.path("rabbitmq_version").asText());
                rabbitMQNodeVo.setMetric(metric);
                valueItem.setTValue(this.prometheusService.UnTimeUnix(valueNode.get(0).asDouble()));
                valueItem.setSValue(valueNode.get(1).asText());
                rabbitMQNodeVo.setValue(valueItem);
                rabbitMQNodeVoList.add(rabbitMQNodeVo);
            }
            return rabbitMQNodeVoList;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

