/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.optional;

import cn.hutool.core.collection.CollUtil;
import java.util.Collection;
import java.util.function.Consumer;

public final class CollectionOptional<T> {
    private final Collection<T> value;

    private CollectionOptional(Collection<T> value) {
        this.value = value;
    }

    public static <T> CollectionOptional<T> ofNullable(Collection<T> value) {
        return new CollectionOptional<T>(value);
    }

    public void ifPresent(Consumer<Collection<T>> action) {
        if (CollUtil.isNotEmpty(this.value)) {
            action.accept(this.value);
        }
    }

    public void ifPresentOrElse(Consumer<Collection<?>> action, Runnable emptyAction) {
        if (CollUtil.isNotEmpty(this.value)) {
            action.accept(this.value);
        } else {
            emptyAction.run();
        }
    }
}

