/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.utils;

import cn.hutool.crypto.digest.MD5;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecodeUtil {
    private static final Logger log = LoggerFactory.getLogger(DecodeUtil.class);

    private DecodeUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String byteToString(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static byte[] stringToByte(String content) {
        return content.getBytes(StandardCharsets.UTF_8);
    }

    public static String md5(String content) {
        MD5 md5 = MD5.create();
        return md5.digestHex(content, StandardCharsets.UTF_8);
    }

    public static String md5(String content, String salt) {
        return DecodeUtil.md5(content + salt);
    }

    public static byte[] encode(byte[] bytes) {
        return Base64.getEncoder().encode(bytes);
    }

    public static byte[] encode(String content) {
        return DecodeUtil.encode(DecodeUtil.stringToByte(content));
    }

    public static byte[] decode(byte[] bytes) {
        return Base64.getDecoder().decode(bytes);
    }

    public static byte[] decode(String content) {
        return DecodeUtil.decode(DecodeUtil.stringToByte(content));
    }
}

