/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.utils;

import io.github.pnoker.common.constant.common.TimeConstant;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDateTimeUtil {
    private static final Logger log = LoggerFactory.getLogger(LocalDateTimeUtil.class);

    private LocalDateTimeUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static DateTimeFormatter getDefaultDateTimeFormatter() {
        return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(TimeConstant.DEFAULT_ZONEID);
    }

    public static DateTimeFormatter getCompleteDateTimeFormatter() {
        return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(TimeConstant.DEFAULT_ZONEID);
    }

    public static long milliSeconds(LocalDateTime localDateTime) {
        return localDateTime.atZone(TimeConstant.DEFAULT_ZONEID).toInstant().toEpochMilli();
    }

    public static LocalDateTime localDateTime(long milliSeconds) {
        Instant instant = Instant.ofEpochMilli(milliSeconds);
        return LocalDateTime.ofInstant(instant, TimeConstant.DEFAULT_ZONEID);
    }

    public static LocalDateTime expireTime(int amount, ChronoUnit field) {
        LocalDateTime localDateTime = LocalDateTime.now();
        return localDateTime.plus(amount, field);
    }

    public static String defaultFormat(LocalDateTime localDateTime) {
        DateTimeFormatter formatter = LocalDateTimeUtil.getDefaultDateTimeFormatter();
        return localDateTime.format(formatter);
    }

    public static String completeFormat(LocalDateTime localDateTime) {
        DateTimeFormatter formatter = LocalDateTimeUtil.getCompleteDateTimeFormatter();
        return localDateTime.format(formatter);
    }

    public static LocalDateTime defaultDate(String dateString) {
        try {
            DateTimeFormatter formatter = LocalDateTimeUtil.getDefaultDateTimeFormatter();
            return LocalDateTime.parse(dateString, formatter);
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    public static LocalDateTime completeDate(String dateString) {
        try {
            DateTimeFormatter formatter = LocalDateTimeUtil.getCompleteDateTimeFormatter();
            return LocalDateTime.parse(dateString, formatter);
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }
}

