/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.utils;

import io.github.pnoker.common.exception.ConnectorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Objects;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509Util {
    private static final Logger log = LoggerFactory.getLogger(X509Util.class);

    private X509Util() {
        throw new IllegalStateException("Utility class");
    }

    public static SSLSocketFactory getSSLSocketFactory(String caCrtFile, String crtFile, String keyFile, String password) {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            X509Certificate caCert = (X509Certificate)X509Util.loadCertificate(caCrtFile);
            KeyStore caKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            caKeyStore.load(null, null);
            caKeyStore.setCertificateEntry("cacertfile", caCert);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(caKeyStore);
            X509Certificate cert = (X509Certificate)X509Util.loadCertificate(crtFile);
            KeyPair key = (KeyPair)X509Util.loadCertificateWithPassword(keyFile, password);
            KeyStore certKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            certKeyStore.load(null, null);
            certKeyStore.setCertificateEntry("certfile", cert);
            certKeyStore.setKeyEntry("keyfile", key.getPrivate(), password.toCharArray(), new Certificate[]{cert});
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(certKeyStore, password.toCharArray());
            SSLContext context = SSLContext.getInstance("TLSv1.2");
            context.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            return context.getSocketFactory();
        }
        catch (Exception e) {
            throw new ConnectorException((CharSequence)e.getMessage(), new Object[0]);
        }
    }

    private static <T> T loadCertificate(String caCrtFile) throws IOException {
        return X509Util.loadCertificateWithPassword(caCrtFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T loadCertificateWithPassword(String caCrtFile, String password) throws IOException {
        PemReader reader = null;
        try {
            String classPath = "classpath:";
            if (caCrtFile.startsWith(classPath)) {
                InputStream inputStream = X509Util.class.getResourceAsStream(caCrtFile.replace(classPath, ""));
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                reader = Objects.nonNull(password) ? new PemReader((Reader)inputStreamReader) : new PemReader((Reader)inputStreamReader);
            } else {
                Path path = Paths.get(caCrtFile, new String[0]);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(Files.readAllBytes(path));
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                reader = Objects.nonNull(password) ? new PemReader((Reader)inputStreamReader) : new PemReader((Reader)inputStreamReader);
            }
            PemObject pemObject = reader.readPemObject();
            return (T)pemObject;
        }
        finally {
            if (Objects.nonNull(reader)) {
                reader.close();
            }
        }
    }
}

