/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.strategy;

import io.github.pnoker.common.repository.RepositoryService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RepositoryStrategyFactory {
    private static final Map<String, RepositoryService> savingStrategyServiceMap = new ConcurrentHashMap<String, RepositoryService>();

    private RepositoryStrategyFactory() {
        throw new IllegalStateException("Utility class");
    }

    public static List<RepositoryService> get() {
        return new ArrayList<RepositoryService>(savingStrategyServiceMap.values());
    }

    public static RepositoryService get(String name) {
        return savingStrategyServiceMap.get("storage:" + name);
    }

    public static void put(String name, RepositoryService service) {
        savingStrategyServiceMap.put("storage:" + name, service);
    }
}

