/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.config;

import io.github.pnoker.common.entity.R;
import io.github.pnoker.common.exception.NotFoundException;
import io.github.pnoker.common.exception.UnAuthorizedException;
import io.github.pnoker.common.utils.JsonUtil;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.validation.BindException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import reactor.core.publisher.Mono;

@RestControllerAdvice
public class ExceptionConfig {
    private static final Logger log = LoggerFactory.getLogger(ExceptionConfig.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Mono<R<String>> globalException(Exception exception, ServerHttpRequest request) {
        log.error("Global exception handler: {}", (Object)exception.getMessage(), (Object)exception);
        return Mono.just((Object)R.fail((String)exception.getMessage()));
    }

    @ExceptionHandler(value={NotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public Mono<R<String>> notFoundException(NotFoundException exception, ServerHttpRequest request) {
        log.warn("NotFound exception handler: {}", (Object)exception.getMessage(), (Object)exception);
        return Mono.just((Object)R.fail((String)exception.getMessage()));
    }

    @ExceptionHandler(value={UnAuthorizedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public Mono<R<String>> unAuthorizedException(UnAuthorizedException exception, ServerHttpRequest request) {
        log.warn("UnAuthorized exception handler: {}", (Object)exception.getMessage(), (Object)exception);
        return Mono.just((Object)R.fail((String)exception.getMessage()));
    }

    @ExceptionHandler(value={BindException.class, MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.UNPROCESSABLE_ENTITY)
    public Mono<R<String>> methodArgumentNotValidException(MethodArgumentNotValidException exception, ServerHttpRequest request) {
        HashMap map = new HashMap(4);
        List errorList = exception.getBindingResult().getFieldErrors();
        errorList.forEach(error -> {
            log.warn("Method argument not valid exception handler: {}: {}", (Object)error.getField(), (Object)error.getDefaultMessage());
            map.put(error.getField(), error.getDefaultMessage());
        });
        return Mono.just((Object)R.fail((String)JsonUtil.toJsonString(map)));
    }
}

