/*
 * Decompiled with CFR 0.152.
 */
package io.github.pnoker.common.config;

import cn.hutool.core.text.CharSequenceUtil;
import io.github.pnoker.common.entity.common.RequestHeader;
import io.github.pnoker.common.utils.DecodeUtil;
import io.github.pnoker.common.utils.JsonUtil;
import io.github.pnoker.common.utils.RequestUtil;
import io.github.pnoker.common.utils.UserHeaderUtil;
import jakarta.annotation.Resource;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.WebFilter;
import reactor.core.publisher.Mono;

@Configuration
public class WebFilterConfig {
    private static final Logger log = LoggerFactory.getLogger(WebFilterConfig.class);
    @Resource
    private ServerProperties serverProperties;

    @Bean
    public WebFilter contextPathWebFilter() {
        String contextPath = Optional.ofNullable(this.serverProperties.getServlet().getContextPath()).orElse("/");
        return (exchange, chain) -> {
            ServerHttpRequest request = exchange.getRequest();
            if (request.getURI().getPath().startsWith(contextPath)) {
                return chain.filter(exchange.mutate().request(request.mutate().contextPath(contextPath).build()).build());
            }
            return chain.filter(exchange);
        };
    }

    @Bean
    public WebFilter interceptor() {
        return (exchange, chain) -> {
            ServerHttpRequest request = exchange.getRequest();
            String user = RequestUtil.getRequestHeader(request, "X-Auth-User");
            if (CharSequenceUtil.isNotEmpty((CharSequence)user)) {
                byte[] decode = DecodeUtil.decode((String)user);
                try {
                    RequestHeader.UserHeader entityBO = (RequestHeader.UserHeader)JsonUtil.parseObject((byte[])decode, RequestHeader.UserHeader.class);
                    UserHeaderUtil.setUserHeader((RequestHeader.UserHeader)entityBO);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            return chain.filter(exchange).then(Mono.fromRunnable(UserHeaderUtil::removeUserHeader));
        };
    }
}

