/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.KeyValue;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.ScoredValue;
import io.lettuce.core.ScoredValueScanCursor;
import io.lettuce.core.ValueScanCursor;
import io.lettuce.core.api.reactive.RedisHashReactiveCommands;
import io.lettuce.core.api.reactive.RedisKeyReactiveCommands;
import io.lettuce.core.api.reactive.RedisSetReactiveCommands;
import io.lettuce.core.api.reactive.RedisSortedSetReactiveCommands;
import io.lettuce.core.internal.LettuceAssert;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class ScanStream {
    private ScanStream() {
    }

    public static <K, V> Flux<K> scan(RedisKeyReactiveCommands<K, V> commands) {
        return ScanStream.scan(commands, Optional.empty());
    }

    public static <K, V> Flux<K> scan(RedisKeyReactiveCommands<K, V> commands, ScanArgs scanArgs) {
        LettuceAssert.notNull(scanArgs, "ScanArgs must not be null");
        return ScanStream.scan(commands, Optional.of(scanArgs));
    }

    private static <K, V> Flux<K> scan(RedisKeyReactiveCommands<K, V> commands, Optional<ScanArgs> scanArgs) {
        LettuceAssert.notNull(commands, "RedisKeyCommands must not be null");
        Mono res = scanArgs.map(commands::scan).orElseGet(commands::scan);
        return res.flatMapMany(cursor -> ScanStream.scan(scanArgs, cursor, commands::scan, commands::scan, KeyScanCursor::getKeys));
    }

    public static <K, V> Flux<KeyValue<K, V>> hscan(RedisHashReactiveCommands<K, V> commands, K key) {
        return ScanStream.hscan(commands, key, Optional.empty());
    }

    public static <K, V> Flux<KeyValue<K, V>> hscan(RedisHashReactiveCommands<K, V> commands, K key, ScanArgs scanArgs) {
        LettuceAssert.notNull(scanArgs, "ScanArgs must not be null");
        return ScanStream.hscan(commands, key, Optional.of(scanArgs));
    }

    private static <K, V> Flux<KeyValue<K, V>> hscan(RedisHashReactiveCommands<K, V> commands, K key, Optional<ScanArgs> scanArgs) {
        LettuceAssert.notNull(commands, "RedisHashReactiveCommands must not be null");
        LettuceAssert.notNull(key, "Key must not be null");
        Mono res = scanArgs.map(it -> commands.hscan(key, (ScanArgs)it)).orElseGet(() -> commands.hscan(key));
        return res.flatMapMany(cursor -> ScanStream.scan(scanArgs, cursor, c -> commands.hscan(key, (ScanCursor)c), (c, args) -> commands.hscan(key, (ScanCursor)c, (ScanArgs)args), c -> c.getMap().entrySet())).map(me -> KeyValue.fromNullable(me.getKey(), me.getValue()));
    }

    public static <K, V> Flux<V> sscan(RedisSetReactiveCommands<K, V> commands, K key) {
        return ScanStream.sscan(commands, key, Optional.empty());
    }

    public static <K, V> Flux<V> sscan(RedisSetReactiveCommands<K, V> commands, K key, ScanArgs scanArgs) {
        LettuceAssert.notNull(scanArgs, "ScanArgs must not be null");
        return ScanStream.sscan(commands, key, Optional.of(scanArgs));
    }

    private static <K, V> Flux<V> sscan(RedisSetReactiveCommands<K, V> commands, K key, Optional<ScanArgs> scanArgs) {
        LettuceAssert.notNull(commands, "RedisSetReactiveCommands must not be null");
        LettuceAssert.notNull(key, "Key must not be null");
        Mono res = scanArgs.map(it -> commands.sscan(key, (ScanArgs)it)).orElseGet(() -> commands.sscan(key));
        return res.flatMapMany(cursor -> ScanStream.scan(scanArgs, cursor, c -> commands.sscan(key, (ScanCursor)c), (c, args) -> commands.sscan(key, (ScanCursor)c, (ScanArgs)args), ValueScanCursor::getValues));
    }

    public static <K, V> Flux<ScoredValue<V>> zscan(RedisSortedSetReactiveCommands<K, V> commands, K key) {
        return ScanStream.zscan(commands, key, Optional.empty());
    }

    public static <K, V> Flux<ScoredValue<V>> zscan(RedisSortedSetReactiveCommands<K, V> commands, K key, ScanArgs scanArgs) {
        LettuceAssert.notNull(scanArgs, "ScanArgs must not be null");
        return ScanStream.zscan(commands, key, Optional.of(scanArgs));
    }

    private static <K, V> Flux<ScoredValue<V>> zscan(RedisSortedSetReactiveCommands<K, V> commands, K key, Optional<ScanArgs> scanArgs) {
        LettuceAssert.notNull(commands, "RedisSortedSetReactiveCommands must not be null");
        LettuceAssert.notNull(key, "Key must not be null");
        Mono res = scanArgs.map(it -> commands.zscan(key, (ScanArgs)it)).orElseGet(() -> commands.zscan(key));
        return res.flatMapMany(cursor -> ScanStream.scan(scanArgs, cursor, c -> commands.zscan(key, (ScanCursor)c), (c, args) -> commands.zscan(key, (ScanCursor)c, (ScanArgs)args), ScoredValueScanCursor::getValues));
    }

    private static <V, C extends ScanCursor> Publisher<V> scan(Optional<ScanArgs> scanArgs, C cursor, Function<ScanCursor, Mono<C>> scanFunction, BiFunction<ScanCursor, ScanArgs, Mono<C>> scanWithArgsFunction, Function<C, Iterable<V>> manyMapper) {
        Flux stream = Flux.fromIterable(manyMapper.apply(cursor));
        if (!cursor.isFinished()) {
            Mono mono = scanArgs.map(args -> (Mono)scanWithArgsFunction.apply(cursor, (ScanArgs)args)).orElseGet(() -> (Mono)scanFunction.apply(cursor));
            return stream.concatWith((Publisher)mono.flatMapMany(nextCursor -> ScanStream.scan(scanArgs, nextCursor, scanFunction, scanWithArgsFunction, manyMapper)));
        }
        return stream;
    }
}

