/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.support;

import io.lettuce.core.RedisException;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.internal.AbstractInvocationHandler;
import io.lettuce.core.internal.AsyncCloseable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

class ConnectionWrapping {
    ConnectionWrapping() {
    }

    static <T> T wrapConnection(T connection, Origin<T> pool) {
        ReturnObjectOnCloseInvocationHandler<Object> handler = new ReturnObjectOnCloseInvocationHandler<Object>(connection, pool);
        Class<?>[] implementedInterfaces = connection.getClass().getInterfaces();
        Class[] interfaces = new Class[implementedInterfaces.length + 1];
        interfaces[0] = HasTargetConnection.class;
        System.arraycopy(implementedInterfaces, 0, interfaces, 1, implementedInterfaces.length);
        Object proxiedConnection = Proxy.newProxyInstance(connection.getClass().getClassLoader(), interfaces, handler);
        handler.setProxiedConnection(proxiedConnection);
        return (T)proxiedConnection;
    }

    static interface Origin<T> {
        public void returnObject(T var1) throws Exception;

        public CompletableFuture<Void> returnObjectAsync(T var1) throws Exception;
    }

    static interface HasTargetConnection {
        public StatefulConnection<?, ?> getTargetConnection();
    }

    static class DelegateCloseToConnectionInvocationHandler<T extends AsyncCloseable & AutoCloseable>
    extends AbstractInvocationHandler {
        private final T proxiedConnection;
        private final Object api;

        DelegateCloseToConnectionInvocationHandler(T proxiedConnection, Object api) {
            this.proxiedConnection = proxiedConnection;
            this.api = api;
        }

        @Override
        protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getStatefulConnection")) {
                return this.proxiedConnection;
            }
            try {
                if (method.getName().equals("close")) {
                    ((AutoCloseable)this.proxiedConnection).close();
                    return null;
                }
                if (method.getName().equals("close")) {
                    return this.proxiedConnection.closeAsync();
                }
                return method.invoke(this.api, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }

    static class ReturnObjectOnCloseInvocationHandler<T>
    extends AbstractInvocationHandler {
        private T connection;
        private T proxiedConnection;
        private Map<Method, Object> connectionProxies = new ConcurrentHashMap<Method, Object>(5, 1.0f);
        private final Origin<T> pool;

        ReturnObjectOnCloseInvocationHandler(T connection, Origin<T> pool) {
            this.connection = connection;
            this.pool = pool;
        }

        void setProxiedConnection(T proxiedConnection) {
            this.proxiedConnection = proxiedConnection;
        }

        @Override
        protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getStatefulConnection")) {
                return this.proxiedConnection;
            }
            if (method.getName().equals("getTargetConnection")) {
                return this.connection;
            }
            if (this.connection == null) {
                throw new RedisException("Connection is deallocated and cannot be used anymore.");
            }
            if (method.getName().equals("close")) {
                this.pool.returnObject(this.proxiedConnection);
                this.connection = null;
                this.proxiedConnection = null;
                this.connectionProxies.clear();
                return null;
            }
            if (method.getName().equals("closeAsync")) {
                CompletableFuture<Void> future = this.pool.returnObjectAsync(this.proxiedConnection);
                this.connection = null;
                this.proxiedConnection = null;
                this.connectionProxies.clear();
                return future;
            }
            try {
                if (method.getName().equals("sync") || method.getName().equals("async") || method.getName().equals("reactive")) {
                    return this.connectionProxies.computeIfAbsent(method, m -> this.getInnerProxy(method, args));
                }
                return method.invoke(this.connection, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        private Object getInnerProxy(Method method, Object[] args) {
            try {
                Object result = method.invoke(this.connection, args);
                result = Proxy.newProxyInstance(this.getClass().getClassLoader(), result.getClass().getInterfaces(), new DelegateCloseToConnectionInvocationHandler<AsyncCloseable>((AsyncCloseable)this.proxiedConnection, result));
                return result;
            }
            catch (IllegalAccessException e) {
                throw new RedisException(e);
            }
            catch (InvocationTargetException e) {
                throw new RedisException(e.getTargetException());
            }
        }

        public T getConnection() {
            return this.connection;
        }
    }
}

