/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.search.arguments;

import io.lettuce.core.protocol.CommandArgs;

public class SugGetArgs<K, V> {
    private boolean fuzzy;
    private boolean withScores;
    private boolean withPayloads;
    private Long max;

    public SugGetArgs<K, V> fuzzy() {
        this.fuzzy = true;
        return this;
    }

    public SugGetArgs<K, V> withScores() {
        this.withScores = true;
        return this;
    }

    public SugGetArgs<K, V> withPayloads() {
        this.withPayloads = true;
        return this;
    }

    public SugGetArgs<K, V> max(long max) {
        this.max = max;
        return this;
    }

    public boolean isWithScores() {
        return this.withScores;
    }

    public boolean isWithPayloads() {
        return this.withPayloads;
    }

    public void build(CommandArgs<K, V> args) {
        if (this.fuzzy) {
            args.add("FUZZY");
        }
        if (this.withScores) {
            args.add("WITHSCORES");
        }
        if (this.withPayloads) {
            args.add("WITHPAYLOADS");
        }
        if (this.max != null) {
            args.add("MAX").add(this.max);
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static <K, V> SugGetArgs<K, V> fuzzy() {
            return new SugGetArgs().fuzzy();
        }

        public static <K, V> SugGetArgs<K, V> withScores() {
            return new SugGetArgs().withScores();
        }

        public static <K, V> SugGetArgs<K, V> withPayloads() {
            return new SugGetArgs().withPayloads();
        }

        public static <K, V> SugGetArgs<K, V> max(long max) {
            return new SugGetArgs().max(max);
        }
    }
}

