/*
 * Decompiled with CFR 0.152.
 */
package io.livekit.server;

import io.livekit.server.AccessToken;
import io.livekit.server.AgentDispatchService;
import io.livekit.server.AgentDispatchServiceClient;
import io.livekit.server.RoomAdmin;
import io.livekit.server.RoomName;
import io.livekit.server.VideoGrant;
import io.livekit.server.okhttp.OkHttpFactory;
import io.livekit.server.retrofit.TransformCall;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import livekit.LivekitAgentDispatch;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.protobuf.ProtoConverterFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J!\u0010\b\u001a\u00020\u00052\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ*\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u0007J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\u001a\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00160\u000e2\u0006\u0010\u0010\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/livekit/server/AgentDispatchServiceClient;", "", "service", "Lio/livekit/server/AgentDispatchService;", "apiKey", "", "secret", "(Lio/livekit/server/AgentDispatchService;Ljava/lang/String;Ljava/lang/String;)V", "authHeader", "videoGrants", "", "Lio/livekit/server/VideoGrant;", "([Lio/livekit/server/VideoGrant;)Ljava/lang/String;", "createDispatch", "Lretrofit2/Call;", "Llivekit/LivekitAgentDispatch$AgentDispatch;", "room", "agentName", "metadata", "deleteDispatch", "dispatchId", "listDispatch", "", "Companion", "server-sdk-kotlin"})
public final class AgentDispatchServiceClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AgentDispatchService service;
    @NotNull
    private final String apiKey;
    @NotNull
    private final String secret;

    public AgentDispatchServiceClient(@NotNull AgentDispatchService service, @NotNull String apiKey, @NotNull String secret) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        this.service = service;
        this.apiKey = apiKey;
        this.secret = secret;
    }

    @JvmOverloads
    @NotNull
    public final Call<LivekitAgentDispatch.AgentDispatch> createDispatch(@NotNull String room, @NotNull String agentName, @Nullable String metadata) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        Intrinsics.checkNotNullParameter((Object)agentName, (String)"agentName");
        LivekitAgentDispatch.CreateAgentDispatchRequest.Builder $this$createDispatch_u24lambda_u240 = LivekitAgentDispatch.CreateAgentDispatchRequest.newBuilder();
        boolean bl = false;
        $this$createDispatch_u24lambda_u240.setRoom(room);
        $this$createDispatch_u24lambda_u240.setAgentName(agentName);
        if (metadata != null) {
            $this$createDispatch_u24lambda_u240.setMetadata(metadata);
        }
        LivekitAgentDispatch.CreateAgentDispatchRequest request = $this$createDispatch_u24lambda_u240.build();
        VideoGrant[] videoGrantArray = new VideoGrant[]{new RoomAdmin(true), new RoomName(room)};
        String credentials = this.authHeader(videoGrantArray);
        Intrinsics.checkNotNull((Object)request);
        return this.service.createDispatch(request, credentials);
    }

    public static /* synthetic */ Call createDispatch$default(AgentDispatchServiceClient agentDispatchServiceClient, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        return agentDispatchServiceClient.createDispatch(string, string2, string3);
    }

    @NotNull
    public final Call<LivekitAgentDispatch.AgentDispatch> deleteDispatch(@NotNull String room, @NotNull String dispatchId) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        Intrinsics.checkNotNullParameter((Object)dispatchId, (String)"dispatchId");
        LivekitAgentDispatch.DeleteAgentDispatchRequest request = LivekitAgentDispatch.DeleteAgentDispatchRequest.newBuilder().setRoom(room).setDispatchId(dispatchId).build();
        VideoGrant[] videoGrantArray = new VideoGrant[]{new RoomAdmin(true), new RoomName(room)};
        String credentials = this.authHeader(videoGrantArray);
        Intrinsics.checkNotNull((Object)request);
        return this.service.deleteDispatch(request, credentials);
    }

    @NotNull
    public final Call<List<LivekitAgentDispatch.AgentDispatch>> listDispatch(@NotNull String room) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        LivekitAgentDispatch.ListAgentDispatchRequest request = LivekitAgentDispatch.ListAgentDispatchRequest.newBuilder().setRoom(room).build();
        VideoGrant[] videoGrantArray = new VideoGrant[]{new RoomAdmin(true), new RoomName(room)};
        String credentials = this.authHeader(videoGrantArray);
        Intrinsics.checkNotNull((Object)request);
        return new TransformCall(this.service.listDispatch(request, credentials), listDispatch.1.INSTANCE);
    }

    private final String authHeader(VideoGrant ... videoGrants) {
        AccessToken accessToken = new AccessToken(this.apiKey, this.secret);
        accessToken.addGrants(Arrays.copyOf(videoGrants, videoGrants.length));
        String jwt = accessToken.toJwt();
        return "Bearer " + jwt;
    }

    @JvmOverloads
    @NotNull
    public final Call<LivekitAgentDispatch.AgentDispatch> createDispatch(@NotNull String room, @NotNull String agentName) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        Intrinsics.checkNotNullParameter((Object)agentName, (String)"agentName");
        return AgentDispatchServiceClient.createDispatch$default(this, room, agentName, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AgentDispatchServiceClient createClient(@NotNull String host, @NotNull String apiKey, @NotNull String secret, @NotNull Supplier<OkHttpClient> okHttpSupplier) {
        return Companion.createClient(host, apiKey, secret, okHttpSupplier);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AgentDispatchServiceClient createClient(@NotNull String host, @NotNull String apiKey, @NotNull String secret) {
        return Companion.createClient(host, apiKey, secret);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0007\u00a8\u0006\f"}, d2={"Lio/livekit/server/AgentDispatchServiceClient$Companion;", "", "()V", "createClient", "Lio/livekit/server/AgentDispatchServiceClient;", "host", "", "apiKey", "secret", "okHttpSupplier", "Ljava/util/function/Supplier;", "Lokhttp3/OkHttpClient;", "server-sdk-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final AgentDispatchServiceClient createClient(@NotNull String host, @NotNull String apiKey, @NotNull String secret, @NotNull Supplier<OkHttpClient> okHttpSupplier) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
            Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
            Intrinsics.checkNotNullParameter(okHttpSupplier, (String)"okHttpSupplier");
            OkHttpClient okHttpClient = okHttpSupplier.get();
            Intrinsics.checkNotNullExpressionValue((Object)okHttpClient, (String)"get(...)");
            OkHttpClient okhttp = okHttpClient;
            AgentDispatchService service = (AgentDispatchService)new Retrofit.Builder().baseUrl(host).addConverterFactory((Converter.Factory)ProtoConverterFactory.create()).client(okhttp).build().create(AgentDispatchService.class);
            Intrinsics.checkNotNull((Object)service);
            return new AgentDispatchServiceClient(service, apiKey, secret);
        }

        public static /* synthetic */ AgentDispatchServiceClient createClient$default(Companion companion, String string, String string2, String string3, Supplier supplier, int n, Object object) {
            if ((n & 8) != 0) {
                supplier = new OkHttpFactory(false, null, 3, null);
            }
            return companion.createClient(string, string2, string3, supplier);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final AgentDispatchServiceClient createClient(@NotNull String host, @NotNull String apiKey, @NotNull String secret) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
            Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
            return io.livekit.server.AgentDispatchServiceClient$Companion.createClient$default(this, host, apiKey, secret, null, 8, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

