/*
 * Decompiled with CFR 0.152.
 */
package io.livekit.server;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.security.MessageDigest;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import livekit.LivekitWebhook;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\b\u0010\t\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/livekit/server/WebhookReceiver;", "", "apiKey", "", "secret", "(Ljava/lang/String;Ljava/lang/String;)V", "receive", "Llivekit/LivekitWebhook$WebhookEvent;", "body", "authHeader", "skipAuth", "", "server-sdk-kotlin"})
@SourceDebugExtension(value={"SMAP\nWebhookReceiver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebhookReceiver.kt\nio/livekit/server/WebhookReceiver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1#2:63\n*E\n"})
public final class WebhookReceiver {
    @NotNull
    private final String apiKey;
    @NotNull
    private final String secret;

    public WebhookReceiver(@NotNull String apiKey, @NotNull String secret) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        this.apiKey = apiKey;
        this.secret = secret;
    }

    @JvmOverloads
    @NotNull
    public final LivekitWebhook.WebhookEvent receive(@NotNull String body, @Nullable String authHeader, boolean skipAuth) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        if (!skipAuth) {
            if (authHeader == null) {
                boolean $i$a$-requireNotNull-WebhookReceiver$receive$22 = false;
                String $i$a$-requireNotNull-WebhookReceiver$receive$22 = "Auth header is null!";
                throw new IllegalArgumentException($i$a$-requireNotNull-WebhookReceiver$receive$22.toString());
            }
            if (!(!StringsKt.isBlank((CharSequence)authHeader))) {
                boolean $i$a$-require-WebhookReceiver$receive$32 = false;
                String $i$a$-require-WebhookReceiver$receive$32 = "Auth header is blank!";
                throw new IllegalArgumentException($i$a$-require-WebhookReceiver$receive$32.toString());
            }
            Algorithm alg = Algorithm.HMAC256((String)this.secret);
            DecodedJWT decodedJWT = JWT.require((Algorithm)alg).withIssuer(this.apiKey).build().verify(authHeader);
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            String string = body;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] hashBytes = digest.digest(byArray);
            String hash = Base64.getEncoder().encodeToString(hashBytes);
            Claim claim = decodedJWT.getClaim("sha256");
            if (!Intrinsics.areEqual((Object)(claim != null ? claim.asString() : null), (Object)hash)) {
                throw new IllegalArgumentException("sha256 checksum of body does not match!");
            }
        }
        LivekitWebhook.WebhookEvent.Builder builder = LivekitWebhook.WebhookEvent.newBuilder();
        JsonFormat.parser().ignoringUnknownFields().merge(body, (Message.Builder)builder);
        LivekitWebhook.WebhookEvent webhookEvent = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)webhookEvent, (String)"build(...)");
        return webhookEvent;
    }

    public static /* synthetic */ LivekitWebhook.WebhookEvent receive$default(WebhookReceiver webhookReceiver, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return webhookReceiver.receive(string, string2, bl);
    }

    @JvmOverloads
    @NotNull
    public final LivekitWebhook.WebhookEvent receive(@NotNull String body, @Nullable String authHeader) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return WebhookReceiver.receive$default(this, body, authHeader, false, 4, null);
    }
}

