/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.graphite;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import java.util.Arrays;
import java.util.List;

public class GraphiteHierarchicalNameMapper
implements HierarchicalNameMapper {
    private final List<String> tagsAsPrefix;

    public GraphiteHierarchicalNameMapper(String ... tagsAsPrefix) {
        this.tagsAsPrefix = Arrays.asList(tagsAsPrefix);
    }

    public String toHierarchicalName(Meter.Id id, NamingConvention convention) {
        StringBuilder prefix = new StringBuilder();
        for (String tagPrefix : this.tagsAsPrefix) {
            String value = id.getTag(tagPrefix);
            if (value == null) continue;
            prefix.append(convention.tagValue(value)).append(".");
        }
        StringBuilder tags = new StringBuilder();
        for (Tag tag : id.getTags()) {
            if (this.tagsAsPrefix.contains(tag.getKey())) continue;
            tags.append(("." + convention.tagKey(tag.getKey()) + "." + convention.tagValue(tag.getValue())).replace(" ", "_"));
        }
        return prefix.toString() + id.getConventionName(convention) + tags;
    }
}

