/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.signalfx;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.StringEscapeUtils;
import io.micrometer.core.lang.Nullable;

public class SignalFxNamingConvention
implements NamingConvention {
    private final NamingConvention delegate;

    public SignalFxNamingConvention() {
        this(NamingConvention.dot);
    }

    public SignalFxNamingConvention(NamingConvention delegate) {
        this.delegate = delegate;
    }

    public String name(String name, Meter.Type type, @Nullable String baseUnit) {
        String formattedName = StringEscapeUtils.escapeJson((String)this.delegate.name(name, type, baseUnit));
        return formattedName.length() > 256 ? formattedName.substring(0, 256) : formattedName;
    }

    public String tagKey(String key) {
        String conventionKey = this.delegate.tagKey(key);
        if (!(conventionKey = conventionKey.replaceAll("^_", "").replaceAll("^sf_", "")).matches("^[a-zA-Z].*")) {
            conventionKey = "a" + conventionKey;
        }
        if (conventionKey.length() > 128) {
            conventionKey = conventionKey.substring(0, 128);
        }
        return conventionKey;
    }

    public String tagValue(String value) {
        String formattedValue = StringEscapeUtils.escapeJson((String)this.delegate.tagValue(value));
        return formattedValue.length() > 256 ? formattedValue.substring(0, 256) : formattedValue;
    }
}

