/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core;

import io.micrometer.shaded.reactor.core.Disposable;
import io.micrometer.shaded.reactor.core.Exceptions;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import io.micrometer.shaded.reactor.util.concurrent.Queues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.stream.Stream;

public final class Disposables {
    static final Disposable DISPOSED = Disposables.disposed();

    private Disposables() {
    }

    public static Disposable.Composite composite() {
        return new CompositeDisposable();
    }

    public static Disposable.Composite composite(Disposable ... disposables) {
        return new CompositeDisposable(disposables);
    }

    public static Disposable.Composite composite(Iterable<? extends Disposable> disposables) {
        return new CompositeDisposable(disposables);
    }

    public static Disposable disposed() {
        return new AlwaysDisposable();
    }

    public static Disposable never() {
        return new NeverDisposable();
    }

    public static Disposable single() {
        return new SimpleDisposable();
    }

    public static Disposable.Swap swap() {
        return new SwapDisposable();
    }

    static <T> boolean set(AtomicReferenceFieldUpdater<T, Disposable> updater, T holder, @Nullable Disposable newValue) {
        Disposable current;
        do {
            if ((current = updater.get(holder)) != DISPOSED) continue;
            if (newValue != null) {
                newValue.dispose();
            }
            return false;
        } while (!updater.compareAndSet(holder, current, newValue));
        if (current != null) {
            current.dispose();
        }
        return true;
    }

    static <T> boolean replace(AtomicReferenceFieldUpdater<T, Disposable> updater, T holder, @Nullable Disposable newValue) {
        Disposable current;
        do {
            if ((current = updater.get(holder)) != DISPOSED) continue;
            if (newValue != null) {
                newValue.dispose();
            }
            return false;
        } while (!updater.compareAndSet(holder, current, newValue));
        return true;
    }

    static <T> boolean dispose(AtomicReferenceFieldUpdater<T, Disposable> updater, T holder) {
        Disposable d;
        Disposable current = updater.get(holder);
        if (current != (d = DISPOSED) && (current = updater.getAndSet(holder, d)) != d) {
            if (current != null) {
                current.dispose();
            }
            return true;
        }
        return false;
    }

    static boolean isDisposed(Disposable d) {
        return d == DISPOSED;
    }

    static final class NeverDisposable
    implements Disposable {
        NeverDisposable() {
        }

        @Override
        public void dispose() {
        }

        @Override
        public boolean isDisposed() {
            return false;
        }
    }

    static final class AlwaysDisposable
    implements Disposable {
        AlwaysDisposable() {
        }

        @Override
        public void dispose() {
        }

        @Override
        public boolean isDisposed() {
            return true;
        }
    }

    static final class SimpleDisposable
    extends AtomicBoolean
    implements Disposable {
        SimpleDisposable() {
        }

        @Override
        public void dispose() {
            this.set(true);
        }

        @Override
        public boolean isDisposed() {
            return this.get();
        }
    }

    static final class SwapDisposable
    implements Disposable.Swap {
        volatile Disposable inner;
        static final AtomicReferenceFieldUpdater<SwapDisposable, Disposable> INNER = AtomicReferenceFieldUpdater.newUpdater(SwapDisposable.class, Disposable.class, "inner");

        SwapDisposable() {
        }

        @Override
        public boolean update(@Nullable Disposable next) {
            return Disposables.set(INNER, this, next);
        }

        @Override
        public boolean replace(@Nullable Disposable next) {
            return Disposables.replace(INNER, this, next);
        }

        @Override
        @Nullable
        public Disposable get() {
            return this.inner;
        }

        @Override
        public void dispose() {
            Disposables.dispose(INNER, this);
        }

        @Override
        public boolean isDisposed() {
            return Disposables.isDisposed(INNER.get(this));
        }
    }

    static final class CompositeDisposable
    implements Disposable.Composite,
    Scannable {
        static final int DEFAULT_CAPACITY = 16;
        static final float DEFAULT_LOAD_FACTOR = 0.75f;
        final float loadFactor;
        int mask;
        int size;
        int maxSize;
        Disposable[] disposables;
        volatile boolean disposed;
        static final int INT_PHI = -1640531527;

        CompositeDisposable() {
            this.loadFactor = 0.75f;
            int c = 16;
            this.mask = c - 1;
            this.maxSize = (int)(this.loadFactor * (float)c);
            this.disposables = new Disposable[c];
        }

        CompositeDisposable(Disposable ... disposables) {
            Objects.requireNonNull(disposables, "disposables is null");
            int capacity = disposables.length + 1;
            this.loadFactor = 0.75f;
            int c = Queues.ceilingNextPowerOfTwo(capacity);
            this.mask = c - 1;
            this.maxSize = (int)(this.loadFactor * (float)c);
            this.disposables = new Disposable[c];
            for (Disposable d : disposables) {
                Objects.requireNonNull(d, "Disposable item is null");
                this.addEntry(d);
            }
        }

        CompositeDisposable(Iterable<? extends Disposable> disposables) {
            Objects.requireNonNull(disposables, "disposables is null");
            this.loadFactor = 0.75f;
            int c = 16;
            this.mask = c - 1;
            this.maxSize = (int)(this.loadFactor * (float)c);
            this.disposables = new Disposable[c];
            for (Disposable disposable : disposables) {
                Objects.requireNonNull(disposable, "Disposable item is null");
                this.addEntry(disposable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            Disposable[] set;
            if (this.disposed) {
                return;
            }
            CompositeDisposable compositeDisposable = this;
            synchronized (compositeDisposable) {
                if (this.disposed) {
                    return;
                }
                this.disposed = true;
                set = this.disposables;
                this.disposables = null;
                this.size = 0;
            }
            ArrayList<Throwable> errors = null;
            for (Disposable o : set) {
                if (!(o instanceof Disposable)) continue;
                try {
                    o.dispose();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    if (errors == null) {
                        errors = new ArrayList<Throwable>();
                    }
                    errors.add(ex);
                }
            }
            if (errors != null) {
                if (errors.size() == 1) {
                    throw Exceptions.propagate((Throwable)errors.get(0));
                }
                throw Exceptions.multiple((Iterable<Throwable>)errors);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(Disposable d) {
            Objects.requireNonNull(d, "d is null");
            if (!this.disposed) {
                CompositeDisposable compositeDisposable = this;
                synchronized (compositeDisposable) {
                    if (!this.disposed) {
                        this.addEntry(d);
                        return true;
                    }
                }
            }
            d.dispose();
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends Disposable> ds) {
            Objects.requireNonNull(ds, "ds is null");
            if (!this.disposed) {
                CompositeDisposable compositeDisposable = this;
                synchronized (compositeDisposable) {
                    if (!this.disposed) {
                        for (Disposable disposable : ds) {
                            Objects.requireNonNull(disposable, "d is null");
                            this.addEntry(disposable);
                        }
                        return true;
                    }
                }
            }
            for (Disposable disposable : ds) {
                disposable.dispose();
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Disposable d) {
            Objects.requireNonNull(d, "Disposable item is null");
            if (this.disposed) {
                return false;
            }
            CompositeDisposable compositeDisposable = this;
            synchronized (compositeDisposable) {
                if (this.disposed) {
                    return false;
                }
                if (!this.removeEntry(d)) {
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            if (this.disposed) {
                return 0;
            }
            CompositeDisposable compositeDisposable = this;
            synchronized (compositeDisposable) {
                if (this.disposed) {
                    return 0;
                }
                return this.size;
            }
        }

        @Override
        public Stream<? extends Scannable> inners() {
            return Stream.of(this.disposables).filter(Objects::nonNull).map(Scannable::from);
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.CANCELLED) {
                return this.isDisposed();
            }
            return null;
        }

        boolean addEntry(Disposable value) {
            Disposable[] a = this.disposables;
            int m = this.mask;
            int pos = CompositeDisposable.mix(value.hashCode()) & m;
            Disposable curr = a[pos];
            if (curr != null) {
                if (curr.equals(value)) {
                    return false;
                }
                while ((curr = a[pos = pos + 1 & m]) != null) {
                    if (!curr.equals(value)) continue;
                    return false;
                }
            }
            a[pos] = value;
            if (++this.size >= this.maxSize) {
                this.rehash();
            }
            return true;
        }

        boolean removeEntry(Disposable value) {
            Disposable[] a = this.disposables;
            int m = this.mask;
            int pos = CompositeDisposable.mix(value.hashCode()) & m;
            Disposable curr = a[pos];
            if (curr == null) {
                return false;
            }
            if (curr.equals(value)) {
                return this.removeEntry(pos, a, m);
            }
            do {
                if ((curr = a[pos = pos + 1 & m]) != null) continue;
                return false;
            } while (!curr.equals(value));
            return this.removeEntry(pos, a, m);
        }

        boolean removeEntry(int pos, Disposable[] a, int m) {
            --this.size;
            while (true) {
                Disposable curr;
                int last = pos;
                pos = pos + 1 & m;
                while (true) {
                    if ((curr = a[pos]) == null) {
                        a[last] = null;
                        return true;
                    }
                    int slot = CompositeDisposable.mix(curr.hashCode()) & m;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & m;
                }
                a[last] = curr;
            }
        }

        void rehash() {
            Disposable[] a = this.disposables;
            int i = a.length;
            int newCap = i << 1;
            int m = newCap - 1;
            Disposable[] b = new Disposable[newCap];
            int j = this.size;
            while (j-- != 0) {
                while (a[--i] == null) {
                }
                int pos = CompositeDisposable.mix(a[i].hashCode()) & m;
                if (b[pos] != null) {
                    while (b[pos = pos + 1 & m] != null) {
                    }
                }
                b[pos] = a[i];
            }
            this.mask = m;
            this.maxSize = (int)((float)newCap * this.loadFactor);
            this.disposables = b;
        }

        static int mix(int x) {
            int h = x * -1640531527;
            return h ^ h >>> 16;
        }
    }
}

