/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.org.reactorstreams.Subscription;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Fuseable;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.MonoFromFluxOperator;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collector;

final class MonoStreamCollector<T, A, R>
extends MonoFromFluxOperator<T, R>
implements Fuseable {
    final Collector<? super T, A, ? extends R> collector;

    MonoStreamCollector(Flux<? extends T> source, Collector<? super T, A, ? extends R> collector) {
        super(source);
        this.collector = Objects.requireNonNull(collector, "collector");
    }

    @Override
    public void subscribe(CoreSubscriber<? super R> actual) {
        Function<A, ? extends R> finisher;
        BiConsumer<A, ? super T> accumulator;
        A container;
        try {
            container = this.collector.supplier().get();
            accumulator = this.collector.accumulator();
            finisher = this.collector.finisher();
        }
        catch (Throwable ex) {
            Operators.error(actual, Operators.onOperatorError(ex, actual.currentContext()));
            return;
        }
        this.source.subscribe(new StreamCollectorSubscriber<T, A, R>(actual, container, accumulator, finisher));
    }

    static final class StreamCollectorSubscriber<T, A, R>
    extends Operators.MonoSubscriber<T, R> {
        final BiConsumer<? super A, ? super T> accumulator;
        final Function<? super A, ? extends R> finisher;
        A container;
        Subscription s;
        boolean done;

        StreamCollectorSubscriber(CoreSubscriber<? super R> actual, A container, BiConsumer<? super A, ? super T> accumulator, Function<? super A, ? extends R> finisher) {
            super(actual);
            this.container = container;
            this.accumulator = accumulator;
            this.finisher = finisher;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            return super.scanUnsafe(key);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t, this.actual.currentContext());
                return;
            }
            try {
                this.accumulator.accept(this.container, t);
            }
            catch (Throwable ex) {
                this.onError(Operators.onOperatorError(this.s, ex, t, this.actual.currentContext()));
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t, this.actual.currentContext());
                return;
            }
            this.done = true;
            this.container = null;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            R r;
            if (this.done) {
                return;
            }
            this.done = true;
            A a = this.container;
            this.container = null;
            try {
                r = this.finisher.apply(a);
            }
            catch (Throwable ex) {
                this.actual.onError(Operators.onOperatorError(ex, this.actual.currentContext()));
                return;
            }
            this.complete(r);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }
    }
}

