/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.reactor.core.publisher.RingBuffer;
import io.micrometer.shaded.reactor.core.publisher.SingleProducerSequencerFields;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import io.micrometer.shaded.reactor.util.concurrent.WaitStrategy;
import java.util.concurrent.locks.LockSupport;

final class SingleProducerSequencer
extends SingleProducerSequencerFields {
    protected long p1;
    protected long p2;
    protected long p3;
    protected long p4;
    protected long p5;
    protected long p6;
    protected long p7;

    SingleProducerSequencer(int bufferSize, WaitStrategy waitStrategy, @Nullable Runnable spinObserver) {
        super(bufferSize, waitStrategy, spinObserver);
    }

    @Override
    long next() {
        return this.next(1);
    }

    @Override
    long next(int n) {
        long nextValue = this.nextValue;
        long nextSequence = nextValue + (long)n;
        long wrapPoint = nextSequence - (long)this.bufferSize;
        long cachedGatingSequence = this.cachedValue;
        if (wrapPoint > cachedGatingSequence || cachedGatingSequence > nextValue) {
            long minSequence;
            while (wrapPoint > (minSequence = RingBuffer.getMinimumSequence(this.gatingSequences, nextValue))) {
                if (this.spinObserver != null) {
                    this.spinObserver.run();
                }
                LockSupport.parkNanos(1L);
            }
            this.cachedValue = minSequence;
        }
        this.nextValue = nextSequence;
        return nextSequence;
    }

    @Override
    public long getPending() {
        long nextValue = this.nextValue;
        long consumed = RingBuffer.getMinimumSequence(this.gatingSequences, nextValue);
        long produced = nextValue;
        return produced - consumed;
    }

    @Override
    void publish(long sequence) {
        this.cursor.set(sequence);
        this.waitStrategy.signalAllWhenBlocking();
    }

    @Override
    long getHighestPublishedSequence(long lowerBound, long availableSequence) {
        return availableSequence;
    }
}

