/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.ipc.netty;

import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.ChannelHandler;
import io.micrometer.shaded.io.netty.channel.ChannelOutboundHandler;
import io.micrometer.shaded.io.netty.channel.socket.DatagramChannel;
import io.micrometer.shaded.io.netty.channel.socket.ServerSocketChannel;
import io.micrometer.shaded.io.netty.channel.socket.SocketChannel;
import io.micrometer.shaded.reactor.core.Disposable;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.ipc.netty.FutureMono;
import io.micrometer.shaded.reactor.ipc.netty.ReactorNetty;
import java.net.InetSocketAddress;

@FunctionalInterface
public interface NettyContext
extends Disposable {
    public static boolean isPersistent(Channel channel) {
        return !channel.hasAttr(ReactorNetty.PERSISTENT_CHANNEL) || channel.attr(ReactorNetty.PERSISTENT_CHANNEL).get() != false;
    }

    default public NettyContext addHandler(ChannelHandler handler) {
        return this.addHandler(handler.getClass().getSimpleName(), handler);
    }

    default public NettyContext addHandler(String name, ChannelHandler handler) {
        if (handler instanceof ChannelOutboundHandler) {
            this.addHandlerFirst(name, handler);
        } else {
            this.addHandlerLast(name, handler);
        }
        return this;
    }

    default public NettyContext addHandlerLast(ChannelHandler handler) {
        return this.addHandlerLast(handler.getClass().getSimpleName(), handler);
    }

    default public NettyContext addHandlerLast(String name, ChannelHandler handler) {
        ReactorNetty.addHandlerBeforeReactorEndHandlers(this, name, handler);
        return this;
    }

    default public NettyContext addHandlerFirst(ChannelHandler handler) {
        return this.addHandlerFirst(handler.getClass().getSimpleName(), handler);
    }

    default public NettyContext addHandlerFirst(String name, ChannelHandler handler) {
        ReactorNetty.addHandlerAfterReactorCodecs(this, name, handler);
        return this;
    }

    default public InetSocketAddress address() {
        Channel c = this.channel();
        if (c instanceof SocketChannel) {
            return ((SocketChannel)c).remoteAddress();
        }
        if (c instanceof ServerSocketChannel) {
            return ((ServerSocketChannel)c).localAddress();
        }
        if (c instanceof DatagramChannel) {
            InetSocketAddress a = ((DatagramChannel)c).remoteAddress();
            return a != null ? a : ((DatagramChannel)c).localAddress();
        }
        throw new IllegalStateException("Does not have an InetSocketAddress");
    }

    public Channel channel();

    @Override
    default public void dispose() {
        this.channel().close();
    }

    @Override
    default public boolean isDisposed() {
        return !this.channel().isActive();
    }

    default public NettyContext markPersistent(boolean persist) {
        if (persist && !this.channel().hasAttr(ReactorNetty.PERSISTENT_CHANNEL)) {
            return this;
        }
        this.channel().attr(ReactorNetty.PERSISTENT_CHANNEL).set(persist);
        return this;
    }

    default public Mono<Void> onClose() {
        return FutureMono.from(this.channel().closeFuture());
    }

    default public NettyContext onClose(Runnable onClose) {
        this.onClose().subscribe(null, e -> onClose.run(), onClose);
        return this;
    }

    default public NettyContext removeHandler(String name) {
        ReactorNetty.removeHandler(this.channel(), name);
        return this;
    }

    default public NettyContext replaceHandler(String name, ChannelHandler handler) {
        ReactorNetty.replaceHandler(this.channel(), name, handler);
        return this;
    }
}

