/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.ipc.netty.options;

import io.micrometer.shaded.io.netty.bootstrap.ServerBootstrap;
import io.micrometer.shaded.io.netty.buffer.PooledByteBufAllocator;
import io.micrometer.shaded.io.netty.channel.ChannelOption;
import io.micrometer.shaded.io.netty.channel.EventLoopGroup;
import io.micrometer.shaded.io.netty.handler.ssl.JdkSslContext;
import io.micrometer.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.micrometer.shaded.io.netty.handler.ssl.util.SelfSignedCertificate;
import io.micrometer.shaded.io.netty.util.AttributeKey;
import io.micrometer.shaded.reactor.core.Exceptions;
import io.micrometer.shaded.reactor.ipc.netty.options.InetSocketAddressUtil;
import io.micrometer.shaded.reactor.ipc.netty.options.NettyOptions;
import io.micrometer.shaded.reactor.ipc.netty.resources.LoopResources;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.Consumer;

public class ServerOptions
extends NettyOptions<ServerBootstrap, ServerOptions> {
    private final SocketAddress localAddress;

    public static <BUILDER extends Builder<BUILDER>> Builder<BUILDER> builder() {
        return ServerOptions.builder(new ServerBootstrap());
    }

    public static <BUILDER extends Builder<BUILDER>> Builder<BUILDER> builder(ServerBootstrap serverBootstrap) {
        return new Builder(serverBootstrap);
    }

    protected ServerOptions(Builder<?> builder) {
        super(builder);
        this.localAddress = Objects.isNull(((Builder)builder).listenAddress) ? (Objects.isNull(((Builder)builder).host) ? new InetSocketAddress(((Builder)builder).port) : InetSocketAddressUtil.createResolved(((Builder)builder).host, ((Builder)builder).port)) : (((Builder)builder).listenAddress instanceof InetSocketAddress ? InetSocketAddressUtil.replaceWithResolved((InetSocketAddress)((Builder)builder).listenAddress) : ((Builder)builder).listenAddress);
    }

    @Override
    public ServerOptions duplicate() {
        return ((Builder)ServerOptions.builder().from(this)).build();
    }

    @Override
    public ServerBootstrap get() {
        ServerBootstrap b = (ServerBootstrap)super.get();
        this.groupAndChannel(b);
        return b;
    }

    @Override
    public final SocketAddress getAddress() {
        return this.localAddress;
    }

    final void groupAndChannel(ServerBootstrap bootstrap) {
        LoopResources loops = Objects.requireNonNull(this.getLoopResources(), "loopResources");
        boolean useNative = this.preferNative() && !(this.sslContext() instanceof JdkSslContext);
        EventLoopGroup selectorGroup = loops.onServerSelect(useNative);
        EventLoopGroup elg = loops.onServer(useNative);
        bootstrap.group(selectorGroup, elg).channel(loops.onServerChannel(elg));
    }

    @Override
    public String asSimpleString() {
        return "listening on " + this.getAddress();
    }

    @Override
    public String asDetailedString() {
        return "address=" + this.getAddress() + ", " + super.asDetailedString();
    }

    @Override
    public String toString() {
        return "ServerOptions{" + this.asDetailedString() + "}";
    }

    public static class Builder<BUILDER extends Builder<BUILDER>>
    extends NettyOptions.Builder<ServerBootstrap, ServerOptions, BUILDER> {
        private String host;
        private int port;
        private SocketAddress listenAddress;

        protected Builder(ServerBootstrap serverBootstrap) {
            super(serverBootstrap);
            this.defaultServerOptions(serverBootstrap);
        }

        private final void defaultServerOptions(ServerBootstrap bootstrap) {
            ((ServerBootstrap)((ServerBootstrap)bootstrap.option(ChannelOption.SO_REUSEADDR, true)).option(ChannelOption.SO_BACKLOG, 1000)).childOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.SO_RCVBUF, 0x100000).childOption(ChannelOption.SO_SNDBUF, 0x100000).childOption(ChannelOption.AUTO_READ, false).childOption(ChannelOption.SO_KEEPALIVE, true).childOption(ChannelOption.TCP_NODELAY, true).childOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, 30000);
        }

        @Override
        public final <T> BUILDER attr(AttributeKey<T> key, T value) {
            ((ServerBootstrap)this.bootstrapTemplate).childAttr(key, value);
            return (BUILDER)this.get();
        }

        @Override
        public final <T> BUILDER option(ChannelOption<T> key, T value) {
            ((ServerBootstrap)this.bootstrapTemplate).childOption(key, value);
            return (BUILDER)this.get();
        }

        public final <T> BUILDER selectorAttr(AttributeKey<T> key, T value) {
            this.attr((AttributeKey)key, (Object)value);
            return (BUILDER)this.get();
        }

        public final <T> BUILDER selectorOption(ChannelOption<T> key, T value) {
            this.option((ChannelOption)key, (Object)value);
            return (BUILDER)this.get();
        }

        public final BUILDER host(String host) {
            this.host = Objects.isNull(host) ? "localhost" : host;
            return (BUILDER)this.get();
        }

        public final BUILDER port(int port) {
            this.port = Objects.requireNonNull(Integer.valueOf(port), "port");
            return (BUILDER)this.get();
        }

        public final BUILDER listenAddress(SocketAddress listenAddress) {
            this.listenAddress = Objects.requireNonNull(listenAddress, "listenAddress");
            return (BUILDER)this.get();
        }

        public final BUILDER sslSelfSigned() {
            return this.sslSelfSigned(c -> {});
        }

        public final BUILDER sslSelfSigned(Consumer<? super SslContextBuilder> configurator) {
            Objects.requireNonNull(configurator, "configurator");
            try {
                SelfSignedCertificate ssc = new SelfSignedCertificate();
                SslContextBuilder builder = SslContextBuilder.forServer(ssc.certificate(), ssc.privateKey());
                configurator.accept(builder);
                this.sslContext(builder.build());
                return (BUILDER)this.get();
            }
            catch (Exception sslException) {
                throw Exceptions.bubble(sslException);
            }
        }

        @Override
        public final BUILDER from(ServerOptions options) {
            super.from(options);
            this.listenAddress = options.localAddress;
            return (BUILDER)this.get();
        }

        @Override
        public BUILDER get() {
            return (BUILDER)this;
        }

        public ServerOptions build() {
            return new ServerOptions(this);
        }
    }
}

